/*
 * Decompiled with CFR 0.152.
 */
package org.orangeplayer.common.cmd;

import java.util.Arrays;

public class Command {
    private final String order;
    private final String[] options;

    public Command(String order, String ... options) {
        this.order = order;
        this.options = options;
    }

    public Command(String strCmd) {
        String[] splitcmd = strCmd.split(" ");
        this.order = splitcmd[0];
        this.options = splitcmd.length > 1 ? Arrays.copyOfRange(splitcmd, 1, splitcmd.length) : null;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public int getOptionsCount() {
        return this.hasOptions() ? this.options.length : 0;
    }

    public String getOptionAt(int index) {
        return this.hasOptions() ? (this.getOptionsCount() > index ? this.options[index] : null) : null;
    }

    public Number getOptionAsNumber(int index) {
        String option = this.getOptionAt(index);
        try {
            return option == null ? null : Double.valueOf(Double.parseDouble(option));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getOrder() {
        return this.order;
    }

    public String[] getOptions() {
        return this.options;
    }
}

