/*
 * Decompiled with CFR 0.152.
 */
package org.aucom.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.aucom.sound.AudioInterface;
import org.aucom.sound.AudioQuality;

public class Microphone
extends AudioInterface {
    private volatile TargetDataLine driver;

    public Microphone() throws LineUnavailableException {
        this.driver = (TargetDataLine)AudioSystem.getLine(this.getLineInfo(AudioQuality.DEFAULT_QUALITY));
    }

    public Microphone(AudioFormat quality) throws LineUnavailableException {
        this.configure(quality);
    }

    public Microphone(TargetDataLine driver) {
        super(driver.getFormat());
        this.driver = driver;
    }

    @Override
    protected synchronized DataLine.Info getLineInfo(AudioFormat format) {
        return new DataLine.Info(TargetDataLine.class, format);
    }

    @Override
    public synchronized void configure(AudioFormat format) throws LineUnavailableException {
        this.driver = (TargetDataLine)AudioSystem.getLine(this.getLineInfo(format));
    }

    @Override
    public synchronized boolean isOpen() {
        return this.driver.isOpen();
    }

    public AudioInputStream getInputStream() {
        return new AudioInputStream(this.driver);
    }

    public synchronized TargetDataLine getDriver() {
        return this.driver;
    }

    @Override
    public synchronized DataLine.Info getDriverInfo() {
        return (DataLine.Info)this.driver.getLineInfo();
    }

    public void setDriver(TargetDataLine driver) {
        if (driver != null && driver.isOpen()) {
            this.close();
        }
        this.driver = driver;
    }

    @Override
    public synchronized void setDriverInfo(DataLine.Info driverInfo) throws LineUnavailableException {
        if (this.driver != null) {
            this.driver.close();
            this.driver = (TargetDataLine)AudioSystem.getLine(driverInfo);
        }
    }

    @Override
    public synchronized AudioFormat getFormat() {
        return this.driver.getFormat();
    }

    @Override
    public synchronized FloatControl getControl(FloatControl.Type type) {
        return (FloatControl)this.driver.getControl(type);
    }

    @Override
    public synchronized void open() throws LineUnavailableException {
        AudioFormat lineFormat = this.driver.getFormat();
        this.driver.open(lineFormat == null ? AudioQuality.DEFAULT_QUALITY : lineFormat);
        this.driver.start();
    }

    @Override
    public synchronized void stop() {
        this.driver.stop();
    }

    @Override
    public synchronized void close() {
        this.driver.close();
    }

    public synchronized void reopen() throws LineUnavailableException {
        if (this.driver.isOpen()) {
            this.driver.stop();
        }
        this.open();
    }

    public byte[] readAudio() {
        return this.readAudio(4096);
    }

    public byte[] readAudio(int len) {
        byte[] audioBuff = new byte[len];
        this.driver.read(audioBuff, 0, len);
        return audioBuff;
    }

    public int readAudio(byte[] buffer, int off, int len) {
        if (off >= len) {
            throw new IndexOutOfBoundsException();
        }
        if (off < 0) {
            off = 0;
        }
        if (len > buffer.length) {
            len = buffer.length;
        }
        return this.driver.read(buffer, off, len);
    }
}

