/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats;

import com.sun.media.sound.AiffFileReader;
import com.sun.media.sound.AuFileReader;
import com.sun.media.sound.WaveFileReader;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Track;

public class PCMTrack
extends Track {
    public PCMTrack(File ftrack) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(ftrack);
    }

    public PCMTrack(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath);
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        String extension;
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(this.dataSource);
        switch (extension = '.' + fileFormat.getType().getExtension().toLowerCase()) {
            case ".wav": {
                this.audioReader = new WaveFileReader();
                break;
            }
            case ".aiff": {
                this.audioReader = new AiffFileReader();
                break;
            }
            case ".aifc": {
                this.audioReader = new AiffFileReader();
                break;
            }
            default: {
                this.audioReader = new AuFileReader();
            }
        }
        this.trackStream = this.audioReader.getAudioInputStream(this.dataSource);
    }
}

