/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import javax.sound.sampled.SourceDataLine;
import org.muplayer.audio.SeekOption;
import org.muplayer.audio.Track;
import org.muplayer.main.ConsolePlayer;
import org.orangelogger.sys.Logger;

public class MusicPlayer
extends ConsolePlayer {
    public MusicPlayer(File rootFolder) throws FileNotFoundException {
        super(rootFolder);
    }

    public MusicPlayer(String folder) throws FileNotFoundException {
        super(folder);
    }

    @Override
    public void run() {
        System.out.println("Sounds total: " + this.player.getSongsCount());
        this.player.start();
        Scanner scan = new Scanner(System.in);
        Object playerLine = null;
        boolean on = true;
        while (on) {
            try {
                String line = scan.nextLine().trim();
                char c = line.charAt(0);
                switch (c) {
                    case 'n': {
                        if (line.length() > 1) {
                            if (line.length() == 2 && line.charAt(1) == 'f') {
                                this.player.seekFolder(SeekOption.NEXT);
                                break;
                            }
                            this.player.jumpTrack(Integer.parseInt(line.substring(2)), SeekOption.NEXT);
                            break;
                        }
                        this.player.playNext();
                        break;
                    }
                    case 'p': {
                        if (line.length() > 1) {
                            if (line.length() == 2 && line.charAt(1) == 'f') {
                                this.player.seekFolder(SeekOption.PREV);
                                break;
                            }
                            this.player.jumpTrack(Integer.parseInt(line.substring(2)), SeekOption.PREV);
                            break;
                        }
                        this.player.playPrevious();
                        break;
                    }
                    case 's': {
                        this.player.stopTrack();
                        break;
                    }
                    case 'r': {
                        this.player.resumeTrack();
                        break;
                    }
                    case 'm': {
                        this.player.pause();
                        break;
                    }
                    case 'v': {
                        this.player.setGain(Float.parseFloat(line.substring(2).trim()));
                        break;
                    }
                    case 'k': {
                        this.player.seek(Integer.parseInt(line.substring(2).trim()));
                        break;
                    }
                    case 'e': {
                        on = false;
                        this.player.shutdown();
                        break;
                    }
                    case 'u': {
                        this.player.reloadTracks();
                        break;
                    }
                    case 'w': {
                        System.out.println(this.player.getProgress());
                        break;
                    }
                    case 'g': {
                        this.player.getCurrent().gotoSecond(Integer.parseInt(line.substring(2).trim()));
                        break;
                    }
                    case 'c': {
                        System.out.println(this.player.getSongsCount());
                        break;
                    }
                    case 'l': {
                        int lineLen = line.length();
                        if (lineLen == 2) {
                            if (line.charAt(1) == 'f') {
                                this.player.printFolders();
                                break;
                            }
                            if (line.charAt(1) != 'c') break;
                            this.player.printFolderTracks();
                            break;
                        }
                        this.player.printTracks();
                        break;
                    }
                    case 'd': {
                        System.out.println(this.player.getCurrent().getDurationAsString());
                        break;
                    }
                    case 'x': {
                        System.out.println("ParentFile: " + this.player.getCurrent().getDataSource().getParentFile().getName());
                        break;
                    }
                    case 'f': {
                        Track cur = this.player.getCurrent();
                        String curClassName = cur.getClass().getSimpleName();
                        curClassName = curClassName.substring(0, curClassName.length() - 5).toLowerCase();
                        System.out.println(cur.getFormat() + ' ' + curClassName);
                        break;
                    }
                    case 'i': {
                        this.player.getCurrent().getLineInfo();
                        break;
                    }
                    case '1': {
                        System.out.println(this.player.getCurrent().getTrackLine().getDriver().getMicrosecondPosition() / 1000000L);
                        break;
                    }
                    case '2': {
                        SourceDataLine driver = this.player.getCurrent().getTrackLine().getDriver();
                        double seconds = (double)driver.getMicrosecondPosition() / 1000000.0;
                        long longFramePosition = driver.getLongFramePosition();
                        float frameRate = driver.getFormat().getFrameRate();
                        int frameSize = driver.getFormat().getFrameSize();
                        Track current = this.player.getCurrent();
                        double currentFrames = (double)frameRate * seconds;
                        double totalFrames = frameRate * (float)current.getDuration();
                        System.out.println("TotalFrames: " + totalFrames);
                        System.out.println("TotalSize: " + Math.round(totalFrames * (double)frameSize));
                        System.out.println("FileLenght: " + current.getDataSource().length());
                        break;
                    }
                    case '3': {
                        System.out.println(this.player.getCurrent().getTrackLine().getDriver().available());
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(MusicPlayer.class, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
            }
        }
    }

    public static void main(String[] args) {
        boolean hasArgs = args != null && args.length > 0;
        String fPath = hasArgs ? args[0] : "/home/martin/Escritorio/Archivos/M\u00fasica";
        MusicPlayer musicPlayer = null;
        try {
            musicPlayer = new MusicPlayer(fPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        musicPlayer.start();
    }
}

