/*
 * Decompiled with CFR 0.152.
 */
package org.aucom.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.aucom.sound.AudioInterface;
import org.aucom.sound.AudioQuality;

public class Speaker
extends AudioInterface {
    private volatile SourceDataLine driver;

    public Speaker() throws LineUnavailableException {
        this.driver = (SourceDataLine)AudioSystem.getLine(this.getLineInfo(AudioQuality.DEFAULT_QUALITY));
    }

    public Speaker(AudioFormat quality) throws LineUnavailableException {
        this.configure(quality);
    }

    public Speaker(SourceDataLine driver) {
        super(driver.getFormat());
        this.driver = driver;
    }

    @Override
    protected synchronized DataLine.Info getLineInfo(AudioFormat format) {
        return new DataLine.Info(SourceDataLine.class, format);
    }

    public float getGain() {
        return this.getControl(FloatControl.Type.MASTER_GAIN).getValue();
    }

    public void setGain(float gain) {
        FloatControl control = this.getControl(FloatControl.Type.MASTER_GAIN);
        control.setValue(gain);
    }

    @Override
    public synchronized void configure(AudioFormat quality) throws LineUnavailableException {
        this.driver = (SourceDataLine)AudioSystem.getLine(this.getLineInfo(quality));
    }

    @Override
    public synchronized boolean isOpen() {
        return this.driver.isOpen();
    }

    public synchronized SourceDataLine getDriver() {
        return this.driver;
    }

    @Override
    public synchronized DataLine.Info getDriverInfo() {
        return (DataLine.Info)this.driver.getLineInfo();
    }

    public void setDriver(SourceDataLine driver) {
        if (driver != null && driver.isOpen()) {
            this.close();
            this.driver = driver;
        }
    }

    @Override
    public void setDriverInfo(DataLine.Info driverInfo) throws LineUnavailableException {
        if (this.driver != null) {
            this.driver.close();
            this.driver = (SourceDataLine)AudioSystem.getLine(driverInfo);
        }
    }

    @Override
    public synchronized AudioFormat getFormat() {
        return this.driver.getFormat();
    }

    @Override
    public synchronized FloatControl getControl(FloatControl.Type type) {
        try {
            return (FloatControl)this.driver.getControl(type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public synchronized void open() throws LineUnavailableException {
        AudioFormat lineFormat = this.driver.getFormat();
        this.driver.open(lineFormat == null ? AudioQuality.DEFAULT_QUALITY : lineFormat);
        this.driver.start();
    }

    @Override
    public synchronized void stop() {
        this.driver.stop();
    }

    @Override
    public synchronized void close() {
        this.driver.close();
    }

    public void playAudio(byte[] audioBuff) {
        if (audioBuff == null) {
            return;
        }
        this.driver.write(audioBuff, 0, audioBuff.length);
    }

    public void playAudio(byte[] audioBuff, int len) {
        if (audioBuff == null) {
            return;
        }
        if (len > audioBuff.length) {
            len = audioBuff.length;
        }
        this.driver.write(audioBuff, 0, len);
    }
}

