/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class VideoStreamChunk
extends StreamChunk {
    private byte[] codecId = new byte[0];
    private long pictureHeight;
    private long pictureWidth;

    public VideoStreamChunk(BigInteger chunkLen) {
        super(GUID.GUID_VIDEOSTREAM, chunkLen);
    }

    public byte[] getCodecId() {
        return (byte[])this.codecId.clone();
    }

    public String getCodecIdAsString() {
        String result = this.codecId == null ? "Unknown" : new String(this.getCodecId());
        return result;
    }

    public long getPictureHeight() {
        return this.pictureHeight;
    }

    public long getPictureWidth() {
        return this.pictureWidth;
    }

    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        result.insert(0, Utils.LINE_SEPARATOR + prefix + "|->VideoStream");
        result.append(prefix).append("Video info:").append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("      |->Width  : ").append(this.getPictureWidth()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("      |->Heigth : ").append(this.getPictureHeight()).append(Utils.LINE_SEPARATOR);
        result.append(prefix).append("      |->Codec  : ").append(this.getCodecIdAsString()).append(Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setCodecId(byte[] codecIdentifier) {
        this.codecId = (byte[])codecIdentifier.clone();
    }

    public void setPictureHeight(long picHeight) {
        this.pictureHeight = picHeight;
    }

    public void setPictureWidth(long picWidth) {
        this.pictureWidth = picWidth;
    }
}

