/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.tests.ontesting;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jflac.sound.spi.FlacAudioFileReader;
import org.jflac.sound.spi.FlacFormatConversionProvider;
import org.muplayer.audio.Track;
import org.muplayer.audio.formats.FlacTrack;
import org.muplayer.audio.formats.M4ATrack;
import org.muplayer.audio.formats.OGGTrack;
import org.muplayer.audio.formats.PCMTrack;
import org.muplayer.audio.info.AudioTag;
import org.muplayer.audio.util.TrackHandler;
import org.muplayer.main.ConsolePlayer;
import org.muplayer.tests.TestingManager;
import org.orangelogger.sys.Logger;

public class FormatsTesting {
    private static TestingManager manager;

    public static void main(String[] args) throws Exception {
        FormatsTesting.executeFormatTest();
    }

    private static void executeSongTesting(String path) {
        try {
            new PCMTrack(path).start();
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            Logger.getLogger(FormatsTesting.class, "Exception", (Object)e.getMessage()).error();
        }
    }

    private static void executeFormatTest() {
        Scanner scan = new Scanner(System.in);
        File folderTesting = null;
        Thread player = null;
        while (folderTesting == null || !folderTesting.exists()) {
            try {
                String folderName = scan.nextLine();
                System.out.println("Format to test: " + folderName);
                folderTesting = folderName.equals("music") ? new File("/home/martin/Escritorio/Archivos/M\u00fasica") : new File(manager.getProperty("test-path"), folderName);
                player = new ConsolePlayer(folderTesting);
            }
            catch (FileNotFoundException e) {
                folderTesting = null;
            }
        }
        player.start();
        ((ConsolePlayer)player).execCommand("st");
    }

    private static void execBytesTest() throws IOException, UnsupportedAudioFileException {
        String path = "/home/martin/AudioTesting/audio2/flac.flac";
        File audioFile = new File(path);
        FlacAudioFileReader audioReader = new FlacAudioFileReader();
        AudioInputStream flacAis = audioReader.getAudioInputStream(audioFile);
        AudioFormat format = flacAis.getFormat();
        AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getChannels() * 2, format.getSampleRate(), format.isBigEndian());
        AudioInputStream trackStream = new FlacFormatConversionProvider().getAudioInputStream(decodedFormat, flacAis);
        long readed = 0L;
        int seconds = 0;
        int count = 0;
        byte[] buffer = new byte[4096];
        System.out.println("FrameLenght: " + trackStream.getFrameLength());
        long ti = System.currentTimeMillis();
        while (trackStream.available() > 0) {
            readed += (long)trackStream.read(buffer);
            if (System.currentTimeMillis() - ti >= 1000L) {
                System.out.println("Bytes por segundo: " + readed / (long)(++seconds));
                ti = System.currentTimeMillis();
            }
            ++count;
        }
        System.out.println("Iterations: " + count);
    }

    public static void execTitleTest() throws Exception {
        String path = "/home/martin/AudioTesting/test/title.mp3";
        Track track = Track.getTrack(path);
        TrackHandler controls = new TrackHandler(track);
        controls.play();
    }

    public static void execValidTest() throws Exception {
        String path = "/home/martin/AudioTesting/audio2/flac.flac";
        Track track = Track.getTrack(path);
        System.out.println(Track.isValidTrack(path));
        TrackHandler controls = new TrackHandler(track);
        controls.play();
        String infoSong = track.getSongInfo();
        System.out.println(infoSong);
    }

    public static void execFlacSeekTest() throws Exception {
        FlacTrack track = new FlacTrack("/home/martin/AudioTesting/audio2/flac.flac");
        new Thread(track).start();
        Scanner scan = new Scanner(System.in);
        AudioTag tagInfo = track.getTagInfo();
        System.out.println(tagInfo.getTagReader().toString());
        System.out.println(track.getDataSource().length());
        System.out.println("Duracion en segundos: " + track.getDurationAsString());
        System.out.println("Duracion formateada: " + track.getFormattedDuration());
        while (true) {
            String line = scan.nextLine();
            char first = line.charAt(0);
            switch (first) {
                case 'k': {
                    int seekSec = Integer.parseInt(line.substring(2));
                    ((Track)track).seek(seekSec);
                }
            }
        }
    }

    public static void execM4ASeekTest() throws Exception {
        File sound = new File("/home/martin/AudioTesting/audio2/m4a.m4a");
        TrackHandler handler = new TrackHandler(new M4ATrack(sound));
        handler.start();
        Scanner scan = new Scanner(System.in);
        while (true) {
            String line = scan.nextLine();
            char first = line.charAt(0);
            switch (first) {
                case 'k': {
                    int seekSec = Integer.parseInt(line.substring(2));
                    handler.seek(seekSec);
                }
            }
        }
    }

    public static void execOggTagTest() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        File sound = new File("/home/martin/AudioTesting/audio2/au.ogg");
        OGGTrack track = new OGGTrack(sound);
        new Thread(track).start();
        Scanner scan = new Scanner(System.in);
        while (true) {
            String line = scan.nextLine();
            char first = line.charAt(0);
            switch (first) {
                case 'k': {
                    int seekSec = Integer.parseInt(line.substring(2));
                    ((Track)track).seek(seekSec);
                }
            }
        }
    }

    static {
        try {
            manager = new TestingManager();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

