/*
 * Decompiled with CFR 0.152.
 */
package org.orangelogger.sys;

import java.io.IOException;
import org.orangelogger.sys.SystemUtil;

public class Logger {
    private String className;
    private String title;
    private String msg;
    public static final String INFOCOLOR = "\u001b[32m";
    public static final String WARNINGCOLOR = "\u001b[33m";
    public static final String ERRORCOLOR = "\u001b[31m";
    public static final String RAWCOLOR = "\u001b[37m";

    public static Logger getLogger(String className, String title, Object msg) {
        return new Logger(className, title, msg);
    }

    public static Logger getLogger(Class clazz, String title, Object msg) {
        return new Logger(clazz, title, msg);
    }

    public static Logger getLogger(String className, Object msg) {
        return new Logger(className, msg);
    }

    public static Logger getLogger(Class clazz, Object msg) {
        return new Logger(clazz, msg);
    }

    public static Logger getLogger(Object classObject, Object msg) {
        return new Logger(classObject.getClass(), msg);
    }

    public static Logger getLogger(Object classObject, String title, Object msg) {
        return new Logger(classObject.getClass(), title, msg);
    }

    public static void showLogger(String className, String title, Object msg) {
        new Logger(className, title, msg).printMsg();
    }

    public static void showLogger(Class clazz, String title, Object msg) {
        new Logger(clazz, title, msg).printMsg();
    }

    public static void showLogger(String className, Object msg) {
        new Logger(className, msg).printMsg();
    }

    public static void showLogger(Class clazz, Object msg) {
        new Logger(clazz, msg).printMsg();
    }

    public static void showLogger(Object classObject, Object msg) {
        new Logger(classObject.getClass().getSimpleName(), msg).printMsg();
    }

    public static void showLogger(Object classObject, String title, Object msg) {
        new Logger(classObject.getClass().getSimpleName(), title, msg).printMsg();
    }

    public Logger(String className, String title, Object msg) {
        this.className = className;
        this.title = title;
        this.msg = String.valueOf(msg);
    }

    public Logger(Class clazz, String title, Object msg) {
        this(clazz.getSimpleName(), title, msg);
    }

    public Logger(String className, Object msg) {
        this(className, null, msg);
    }

    public Logger(Class clazz, Object msg) {
        this(clazz.getSimpleName(), msg);
    }

    private String getMsg(String color) {
        StringBuilder sbMsg = new StringBuilder(color);
        sbMsg.append(this.className).append("-> ");
        if (this.title != null) {
            sbMsg.append(this.title).append(": ");
        }
        sbMsg.append(this.msg);
        sbMsg.append("\u001b[0m");
        return sbMsg.toString();
    }

    private String getRawMsg(String color) {
        return color + this.msg + "\u001b[0m";
    }

    private void println(String str) {
        try {
            SystemUtil.getStdout().write(str.concat("\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void print(String str) {
        try {
            SystemUtil.getStdout().write(str.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void error() {
        this.println(this.getMsg(ERRORCOLOR));
    }

    public void info() {
        this.println(this.getMsg(INFOCOLOR));
    }

    public void warning() {
        this.println(this.getMsg(WARNINGCOLOR));
    }

    public void message() {
        this.println(this.getMsg(RAWCOLOR));
    }

    public void rawError() {
        this.println(this.getRawMsg(ERRORCOLOR));
    }

    public void rawInfo() {
        this.println(this.getRawMsg(INFOCOLOR));
    }

    public void rawWarning() {
        this.println(this.getRawMsg(WARNINGCOLOR));
    }

    public void rawMessage() {
        this.println(this.getRawMsg(RAWCOLOR));
    }

    public void printMsg() {
        this.info();
    }

    public void printRawMsg() {
        this.rawInfo();
    }

    public void printMsg(TYPE type) {
        switch (type) {
            case INFO: {
                this.info();
                break;
            }
            case ERROR: {
                this.error();
                break;
            }
            case WARNING: {
                this.warning();
            }
        }
    }

    public void printRawMsg(TYPE type) {
        switch (type) {
            case INFO: {
                this.rawInfo();
                break;
            }
            case ERROR: {
                this.rawError();
                break;
            }
            case WARNING: {
                this.rawWarning();
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getColoredMsg(String color) {
        return this.getRawMsg(color);
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static enum TYPE {
        INFO,
        WARNING,
        ERROR;

    }
}

