/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;

class JavadocMemberEnter
extends MemberEnter {
    final DocEnv docenv;

    public static JavadocMemberEnter instance0(Context context) {
        MemberEnter memberEnter = (MemberEnter)context.get(memberEnterKey);
        if (memberEnter == null) {
            memberEnter = new JavadocMemberEnter(context);
        }
        return (JavadocMemberEnter)memberEnter;
    }

    public static void preRegister(final Context context) {
        context.put(memberEnterKey, new Context.Factory<MemberEnter>(){

            @Override
            public MemberEnter make() {
                return new JavadocMemberEnter(context);
            }
        });
    }

    protected JavadocMemberEnter(Context context) {
        super(context);
        this.docenv = DocEnv.instance(context);
    }

    public void visitMethodDef(Tree.MethodDef methodDef) {
        super.visitMethodDef(methodDef);
        Symbol.MethodSymbol methodSymbol = methodDef.sym;
        if (methodSymbol == null || methodSymbol.kind != 16) {
            return;
        }
        String string = this.env.toplevel.docComments.get(methodDef);
        if (methodSymbol.isConstructor()) {
            this.docenv.makeConstructorDoc(methodSymbol, string, methodDef);
        } else if (JavadocMemberEnter.isAnnotationTypeElement(methodSymbol)) {
            this.docenv.makeAnnotationTypeElementDoc(methodSymbol, string, methodDef);
        } else {
            this.docenv.makeMethodDoc(methodSymbol, string, methodDef);
        }
    }

    public void visitVarDef(Tree.VarDef varDef) {
        super.visitVarDef(varDef);
        if (varDef.sym != null && varDef.sym.kind == 4 && !JavadocMemberEnter.isParameter(varDef.sym)) {
            String string = this.env.toplevel.docComments.get(varDef);
            this.docenv.makeFieldDoc(varDef.sym, string, varDef);
        }
    }

    private static boolean isAnnotationTypeElement(Symbol.MethodSymbol methodSymbol) {
        return ClassDocImpl.isAnnotationType(methodSymbol.enclClass());
    }

    private static boolean isParameter(Symbol.VarSymbol varSymbol) {
        return (varSymbol.flags() & 0x200000000L) != 0L;
    }
}

