/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.syntax;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.SampleFrequency;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.aac.syntax.CCE;
import net.sourceforge.jaad.aac.syntax.CPE;
import net.sourceforge.jaad.aac.syntax.Constants;
import net.sourceforge.jaad.aac.syntax.Element;
import net.sourceforge.jaad.aac.syntax.SCE_LFE;

class FIL
extends Element
implements Constants {
    private static final int TYPE_FILL = 0;
    private static final int TYPE_FILL_DATA = 1;
    private static final int TYPE_EXT_DATA_ELEMENT = 2;
    private static final int TYPE_DYNAMIC_RANGE = 11;
    private static final int TYPE_SBR_DATA = 13;
    private static final int TYPE_SBR_DATA_CRC = 14;
    private final boolean downSampledSBR;
    private DynamicRangeInfo dri;

    FIL(boolean downSampledSBR) {
        this.downSampledSBR = downSampledSBR;
    }

    void decode(BitStream in, Element prev, SampleFrequency sf, boolean sbrEnabled, boolean smallFrames) throws AACException {
        int count = in.readBits(4);
        if (count == 15) {
            count += in.readBits(8) - 1;
        }
        int cpy = count *= 8;
        int pos = in.getPosition();
        while (count > 0) {
            count = this.decodeExtensionPayload(in, count, prev, sf, sbrEnabled, smallFrames);
        }
        int pos2 = in.getPosition() - pos;
        int bitsLeft = cpy - pos2;
        if (bitsLeft > 0) {
            in.skipBits(pos2);
        } else if (bitsLeft < 0) {
            throw new AACException("FIL element overread: " + bitsLeft);
        }
    }

    private int decodeExtensionPayload(BitStream in, int count, Element prev, SampleFrequency sf, boolean sbrEnabled, boolean smallFrames) throws AACException {
        int type = in.readBits(4);
        int ret = count - 4;
        switch (type) {
            case 11: {
                ret = this.decodeDynamicRangeInfo(in, ret);
                break;
            }
            case 13: 
            case 14: {
                if (sbrEnabled) {
                    if (prev instanceof SCE_LFE || prev instanceof CPE || prev instanceof CCE) {
                        prev.decodeSBR(in, sf, ret, prev instanceof CPE, type == 14, this.downSampledSBR, smallFrames);
                        ret = 0;
                        break;
                    }
                    throw new AACException("SBR applied on unexpected element: " + prev);
                }
                in.skipBits(ret);
                ret = 0;
            }
            default: {
                in.skipBits(ret);
                ret = 0;
            }
        }
        return ret;
    }

    private int decodeDynamicRangeInfo(BitStream in, int count) throws AACException {
        int i;
        if (this.dri == null) {
            this.dri = new DynamicRangeInfo();
        }
        int ret = count;
        int bandCount = 1;
        if (this.dri.pceTagPresent = in.readBool()) {
            this.dri.pceInstanceTag = in.readBits(4);
            this.dri.tagReservedBits = in.readBits(4);
        }
        if (this.dri.excludedChannelsPresent = in.readBool()) {
            ret -= this.decodeExcludedChannels(in);
        }
        if (this.dri.bandsPresent = in.readBool()) {
            this.dri.bandsIncrement = in.readBits(4);
            this.dri.interpolationScheme = in.readBits(4);
            ret -= 8;
            DynamicRangeInfo.access$702(this.dri, new int[bandCount += this.dri.bandsIncrement]);
            for (i = 0; i < bandCount; ++i) {
                ((DynamicRangeInfo)this.dri).bandTop[i] = in.readBits(8);
                ret -= 8;
            }
        }
        if (this.dri.progRefLevelPresent = in.readBool()) {
            this.dri.progRefLevel = in.readBits(7);
            this.dri.progRefLevelReservedBits = in.readBits(1);
            ret -= 8;
        }
        DynamicRangeInfo.access$1102(this.dri, new boolean[bandCount]);
        DynamicRangeInfo.access$1202(this.dri, new int[bandCount]);
        for (i = 0; i < bandCount; ++i) {
            ((DynamicRangeInfo)this.dri).dynRngSgn[i] = in.readBool();
            ((DynamicRangeInfo)this.dri).dynRngCtl[i] = in.readBits(7);
            ret -= 8;
        }
        return ret;
    }

    private int decodeExcludedChannels(BitStream in) throws AACException {
        int exclChs = 0;
        do {
            for (int i = 0; i < 7; ++i) {
                ((DynamicRangeInfo)this.dri).excludeMask[exclChs] = in.readBool();
                ++exclChs;
            }
        } while (exclChs < 57 && in.readBool());
        return exclChs / 7 * 8;
    }

    public static class DynamicRangeInfo {
        private static final int MAX_NBR_BANDS = 7;
        private final boolean[] excludeMask = new boolean[7];
        private final boolean[] additionalExcludedChannels = new boolean[7];
        private boolean pceTagPresent;
        private int pceInstanceTag;
        private int tagReservedBits;
        private boolean excludedChannelsPresent;
        private boolean bandsPresent;
        private int bandsIncrement;
        private int interpolationScheme;
        private int[] bandTop;
        private boolean progRefLevelPresent;
        private int progRefLevel;
        private int progRefLevelReservedBits;
        private boolean[] dynRngSgn;
        private int[] dynRngCtl;

        static /* synthetic */ int[] access$702(DynamicRangeInfo x0, int[] x1) {
            x0.bandTop = x1;
            return x1;
        }

        static /* synthetic */ boolean[] access$1102(DynamicRangeInfo x0, boolean[] x1) {
            x0.dynRngSgn = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1202(DynamicRangeInfo x0, int[] x1) {
            x0.dynRngCtl = x1;
            return x1;
        }
    }
}

