/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Track;
import org.muplayer.audio.codec.DecodeManager;
import org.xiph.speex.spi.SpeexAudioFileReader;
import org.xiph.speex.spi.SpeexFormatConvertionProvider;

public class SpeexTrack
extends Track {
    private SpeexFormatConvertionProvider provider;

    public SpeexTrack(File dataSource) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource);
    }

    public SpeexTrack(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(new File(trackPath));
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        this.provider = new SpeexFormatConvertionProvider();
        this.audioReader = new SpeexAudioFileReader();
        AudioInputStream soundAis = this.audioReader.getAudioInputStream(this.dataSource);
        if (this.trackStream != null) {
            this.trackStream.close();
        }
        AudioFormat targetFormat = DecodeManager.getPcmFormatByMpeg(soundAis.getFormat());
        this.trackStream = this.provider.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, soundAis);
    }
}

