/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.info;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.datatype.Artwork;

public class AudioTag {
    private File fileSource;
    private AudioFile audioFile;
    private Tag tagReader;
    private AudioHeader header;

    public AudioTag(File sound) throws TagException, ReadOnlyFileException, CannotReadException, InvalidAudioFrameException, IOException {
        this.fileSource = sound;
        this.audioFile = AudioFileIO.read(sound);
        this.tagReader = this.audioFile.getTag();
        this.header = this.audioFile.getAudioHeader();
    }

    public AudioTag(String soundPath) throws ReadOnlyFileException, IOException, TagException, InvalidAudioFrameException, CannotReadException {
        this(new File(soundPath));
    }

    public boolean isValidFile() {
        return this.tagReader != null;
    }

    public boolean hasCover() {
        return this.isValidFile() && this.getCover() != null;
    }

    public File getFileSource() {
        return this.fileSource;
    }

    public Tag getTagReader() {
        return this.tagReader;
    }

    public AudioHeader getHeader() {
        return this.header;
    }

    public Iterator<TagField> getTags() {
        return this.tagReader.getFields();
    }

    public String getTag(FieldKey tag) {
        if (this.tagReader == null) {
            return null;
        }
        String tagValue = this.tagReader.getFirst(tag);
        return tagValue == null || tagValue.isEmpty() ? null : tagValue.trim();
    }

    public String getTag(String tagName) {
        return this.getTag(FieldKey.valueOf(tagName.toUpperCase()));
    }

    public int getDuration() {
        return this.header.getTrackLength();
    }

    public Artwork getCover() {
        return this.tagReader.getFirstArtwork();
    }

    public byte[] getCoverData() {
        return this.hasCover() ? this.getCover().getBinaryData() : null;
    }
}

