/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.tty.BreakpointSpec;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.ExceptionSpec;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ThreadGroupIterator;
import com.sun.tools.example.debug.tty.ThreadInfo;
import com.sun.tools.example.debug.tty.ThreadIterator;
import com.sun.tools.example.debug.tty.VMConnection;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import com.sun.tools.example.debug.tty.WatchpointSpec;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

class Commands {
    Commands() {
    }

    private Value evaluate(String string) {
        Value value = null;
        ExpressionParser.GetFrame getFrame = null;
        try {
            final ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo != null && threadInfo.getCurrentFrame() != null) {
                getFrame = new ExpressionParser.GetFrame(){

                    public StackFrame get() throws IncompatibleThreadStateException {
                        return threadInfo.getCurrentFrame();
                    }
                };
            }
            value = ExpressionParser.evaluate(string, Env.vm(), getFrame);
        }
        catch (InvocationException invocationException) {
            MessageOutput.println("Exception in expression:", invocationException.exception().referenceType().name());
        }
        catch (Exception exception) {
            String string2;
            String string3 = exception.getMessage();
            if (string3 == null) {
                MessageOutput.printException(string3, exception);
            }
            try {
                string2 = MessageOutput.format(string3);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = exception.toString();
            }
            MessageOutput.printDirectln(string2);
        }
        return value;
    }

    private String getStringValue() {
        Value value = null;
        String string = null;
        try {
            value = ExpressionParser.getMassagedValue();
            string = value.toString();
        }
        catch (com.sun.tools.example.debug.expr.ParseException parseException) {
            String string2;
            String string3 = parseException.getMessage();
            if (string3 == null) {
                MessageOutput.printException(string3, parseException);
            }
            try {
                string2 = MessageOutput.format(string3);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = parseException.toString();
            }
            MessageOutput.printDirectln(string2);
        }
        return string;
    }

    private ThreadInfo doGetThread(String string) {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo(string);
        if (threadInfo == null) {
            MessageOutput.println("is not a valid thread id", string);
        }
        return threadInfo;
    }

    String typedName(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.name());
        stringBuffer.append("(");
        List<String> list = method.argumentTypeNames();
        int n = list.size() - 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(list.get(i));
            stringBuffer.append(", ");
        }
        if (n >= 0) {
            String string = list.get(n);
            if (method.isVarArgs()) {
                stringBuffer.append(string.substring(0, string.length() - 2));
                stringBuffer.append("...");
            } else {
                stringBuffer.append(string);
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    void commandConnectors(VirtualMachineManager virtualMachineManager) {
        Iterator<Connector> iterator = virtualMachineManager.allConnectors().iterator();
        if (iterator.hasNext()) {
            MessageOutput.println("Connectors available");
        }
        while (iterator.hasNext()) {
            Connector connector = iterator.next();
            String string = connector.transport() == null ? "null" : connector.transport().name();
            MessageOutput.println();
            MessageOutput.println("Connector and Transport name", new Object[]{connector.name(), string});
            MessageOutput.println("Connector description", connector.description());
            Iterator<Connector.Argument> iterator2 = connector.defaultArguments().values().iterator();
            if (!iterator2.hasNext()) continue;
            while (iterator2.hasNext()) {
                Connector.Argument argument = iterator2.next();
                MessageOutput.println();
                boolean bl = argument.mustSpecify();
                if (argument.value() == null || argument.value() == "") {
                    MessageOutput.println(bl ? "Connector required argument nodefault" : "Connector argument nodefault", argument.name());
                } else {
                    MessageOutput.println(bl ? "Connector required argument default" : "Connector argument default", new Object[]{argument.name(), argument.value()});
                }
                MessageOutput.println("Connector description", argument.description());
            }
        }
    }

    void commandClasses() {
        List<ReferenceType> list = Env.vm().allClasses();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            ReferenceType referenceType = list.get(i);
            stringBuffer.append(referenceType.name());
            stringBuffer.append("\n");
        }
        MessageOutput.print("** classes list **", stringBuffer.toString());
    }

    void commandClass(StringTokenizer stringTokenizer) {
        ReferenceType referenceType;
        List<ReferenceType> list = Env.vm().allClasses();
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        boolean bl = false;
        if (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer.nextToken().toLowerCase().equals("all")) {
                bl = true;
            } else {
                MessageOutput.println("Invalid option on class command");
                return;
            }
        }
        if ((referenceType = Env.getReferenceTypeFromToken(string)) == null) {
            MessageOutput.println("is not a valid id or class name", string);
            return;
        }
        if (referenceType instanceof ClassType) {
            Object object2;
            ClassType classType = (ClassType)referenceType;
            MessageOutput.println("Class:", classType.name());
            ClassType classType2 = classType.superclass();
            while (classType2 != null) {
                MessageOutput.println("extends:", classType2.name());
                classType2 = bl ? classType2.superclass() : null;
            }
            List<InterfaceType> list2 = bl ? classType.allInterfaces() : classType.interfaces();
            for (InterfaceType interfaceType : list2) {
                MessageOutput.println("implements:", interfaceType.name());
            }
            List<ClassType> list3 = classType.subclasses();
            for (Object object2 : list3) {
                MessageOutput.println("subclass:", object2.name());
            }
            object2 = classType.nestedTypes();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType2 = (ReferenceType)iterator.next();
                MessageOutput.println("nested:", referenceType2.name());
            }
        } else if (referenceType instanceof InterfaceType) {
            Object object3;
            InterfaceType interfaceType = (InterfaceType)referenceType;
            MessageOutput.println("Interface:", interfaceType.name());
            List<InterfaceType> list3 = interfaceType.superinterfaces();
            for (InterfaceType interfaceType2 : list3) {
                MessageOutput.println("extends:", interfaceType2.name());
            }
            List<InterfaceType> list4 = interfaceType.subinterfaces();
            for (InterfaceType interfaceType3 : list4) {
                MessageOutput.println("subinterface:", interfaceType3.name());
            }
            List<ClassType> list5 = interfaceType.implementors();
            for (Object object3 : list5) {
                MessageOutput.println("implementor:", object3.name());
            }
            object3 = interfaceType.nestedTypes();
            Iterator<ReferenceType> iterator = object3.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType3 = iterator.next();
                MessageOutput.println("nested:", referenceType3.name());
            }
        } else {
            ArrayType arrayType = (ArrayType)referenceType;
            MessageOutput.println("Array:", arrayType.name());
        }
    }

    void commandMethods(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
        if (referenceType != null) {
            List<Method> list = referenceType.allMethods();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                Method method = list.get(i);
                stringBuffer.append(method.declaringType().name());
                stringBuffer.append(" ");
                stringBuffer.append(this.typedName(method));
                stringBuffer.append('\n');
            }
            MessageOutput.print("** methods list **", stringBuffer.toString());
        } else {
            MessageOutput.println("is not a valid id or class name", string);
        }
    }

    void commandFields(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
        if (referenceType != null) {
            List<Field> list = referenceType.allFields();
            List<Field> list2 = referenceType.visibleFields();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                Field field = list.get(i);
                String string2 = !list2.contains(field) ? MessageOutput.format("list field typename and name hidden", new Object[]{field.typeName(), field.name()}) : (!((Object)field.declaringType()).equals(referenceType) ? MessageOutput.format("list field typename and name inherited", new Object[]{field.typeName(), field.name(), field.declaringType().name()}) : MessageOutput.format("list field typename and name", new Object[]{field.typeName(), field.name()}));
                stringBuffer.append(string2);
            }
            MessageOutput.print("** fields list **", stringBuffer.toString());
        } else {
            MessageOutput.println("is not a valid id or class name", string);
        }
    }

    private void printThreadGroup(ThreadGroupReference threadGroupReference) {
        ThreadReference threadReference;
        ThreadIterator threadIterator = new ThreadIterator(threadGroupReference);
        MessageOutput.println("Thread Group:", threadGroupReference.name());
        int n = 0;
        int n2 = 0;
        while (threadIterator.hasNext()) {
            threadReference = (ThreadReference)threadIterator.next();
            n = Math.max(n, Env.description(threadReference).length());
            n2 = Math.max(n2, threadReference.name().length());
        }
        threadIterator = new ThreadIterator(threadGroupReference);
        while (threadIterator.hasNext()) {
            String string;
            threadReference = (ThreadReference)threadIterator.next();
            if (threadReference.threadGroup() == null) continue;
            if (!threadReference.threadGroup().equals(threadGroupReference)) {
                threadGroupReference = threadReference.threadGroup();
                MessageOutput.println("Thread Group:", threadGroupReference.name());
            }
            StringBuffer stringBuffer = new StringBuffer(Env.description(threadReference));
            for (int i = stringBuffer.length(); i < n; ++i) {
                stringBuffer.append(" ");
            }
            StringBuffer stringBuffer2 = new StringBuffer(threadReference.name());
            for (int i = stringBuffer2.length(); i < n2; ++i) {
                stringBuffer2.append(" ");
            }
            switch (threadReference.status()) {
                case -1: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name unknownStatus BP";
                        break;
                    }
                    string = "Thread description name unknownStatus";
                    break;
                }
                case 0: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name zombieStatus BP";
                        break;
                    }
                    string = "Thread description name zombieStatus";
                    break;
                }
                case 1: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name runningStatus BP";
                        break;
                    }
                    string = "Thread description name runningStatus";
                    break;
                }
                case 2: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name sleepingStatus BP";
                        break;
                    }
                    string = "Thread description name sleepingStatus";
                    break;
                }
                case 3: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name waitingStatus BP";
                        break;
                    }
                    string = "Thread description name waitingStatus";
                    break;
                }
                case 4: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name condWaitstatus BP";
                        break;
                    }
                    string = "Thread description name condWaitstatus";
                    break;
                }
                default: {
                    throw new InternalError(MessageOutput.format("Invalid thread status."));
                }
            }
            MessageOutput.println(string, new Object[]{stringBuffer.toString(), stringBuffer2.toString()});
        }
    }

    void commandThreads(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.printThreadGroup(ThreadInfo.group());
            return;
        }
        String string = stringTokenizer.nextToken();
        ThreadGroupReference threadGroupReference = ThreadGroupIterator.find(string);
        if (threadGroupReference == null) {
            MessageOutput.println("is not a valid threadgroup name", string);
        } else {
            this.printThreadGroup(threadGroupReference);
        }
    }

    void commandThreadGroups() {
        ThreadGroupIterator threadGroupIterator = new ThreadGroupIterator();
        int n = 0;
        while (threadGroupIterator.hasNext()) {
            ThreadGroupReference threadGroupReference = threadGroupIterator.nextThreadGroup();
            MessageOutput.println("thread group number description name", new Object[]{new Integer(++n), Env.description(threadGroupReference), threadGroupReference.name()});
        }
    }

    void commandThread(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Thread number not specified.");
            return;
        }
        ThreadInfo threadInfo = this.doGetThread(stringTokenizer.nextToken());
        if (threadInfo != null) {
            ThreadInfo.setCurrentThreadInfo(threadInfo);
        }
    }

    void commandThreadGroup(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Threadgroup name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ThreadGroupReference threadGroupReference = ThreadGroupIterator.find(string);
        if (threadGroupReference == null) {
            MessageOutput.println("is not a valid threadgroup name", string);
        } else {
            ThreadInfo.setThreadGroup(threadGroupReference);
        }
    }

    void commandRun(StringTokenizer stringTokenizer) {
        String string;
        VMConnection vMConnection = Env.connection();
        if (!vMConnection.isLaunch()) {
            if (!stringTokenizer.hasMoreTokens()) {
                this.commandCont();
            } else {
                MessageOutput.println("run <args> command is valid only with launched VMs");
            }
            return;
        }
        if (vMConnection.isOpen()) {
            MessageOutput.println("VM already running. use cont to continue after events.");
            return;
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken("");
            boolean bl = vMConnection.setConnectorArg("main", string);
            if (!bl) {
                MessageOutput.println("Unable to set main class and arguments");
                return;
            }
        } else {
            string = vMConnection.connectorArg("main");
            if (string.length() == 0) {
                MessageOutput.println("Main class and arguments must be specified");
                return;
            }
        }
        MessageOutput.println("run", string);
        vMConnection.open();
    }

    void commandLoad(StringTokenizer stringTokenizer) {
        MessageOutput.println("The load command is no longer supported.");
    }

    private List allThreads(ThreadGroupReference threadGroupReference) {
        ArrayList<ThreadReference> arrayList = new ArrayList<ThreadReference>();
        arrayList.addAll(threadGroupReference.threads());
        for (ThreadGroupReference threadGroupReference2 : threadGroupReference.threadGroups()) {
            arrayList.addAll(this.allThreads(threadGroupReference2));
        }
        return arrayList;
    }

    void commandSuspend(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            Env.vm().suspend();
            MessageOutput.println("All threads suspended.");
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                ThreadInfo threadInfo = this.doGetThread(stringTokenizer.nextToken());
                if (threadInfo == null) continue;
                threadInfo.getThread().suspend();
            }
        }
    }

    void commandResume(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            ThreadInfo.invalidateAll();
            Env.vm().resume();
            MessageOutput.println("All threads resumed.");
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                ThreadInfo threadInfo = this.doGetThread(stringTokenizer.nextToken());
                if (threadInfo == null) continue;
                threadInfo.invalidate();
                threadInfo.getThread().resume();
            }
        }
    }

    void commandCont() {
        if (ThreadInfo.getCurrentThreadInfo() == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void clearPreviousStep(ThreadReference threadReference) {
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        List<StepRequest> list = eventRequestManager.stepRequests();
        for (StepRequest stepRequest : list) {
            if (!stepRequest.thread().equals(threadReference)) continue;
            eventRequestManager.deleteEventRequest(stepRequest);
            break;
        }
    }

    void commandStep(StringTokenizer stringTokenizer) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        int n = stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().toLowerCase().equals("up") ? 3 : 1;
        this.clearPreviousStep(threadInfo.getThread());
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(threadInfo.getThread(), -2, n);
        if (n == 1) {
            Env.addExcludes(stepRequest);
        }
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void commandStepi() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        this.clearPreviousStep(threadInfo.getThread());
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(threadInfo.getThread(), -1, 1);
        Env.addExcludes(stepRequest);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void commandNext() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        this.clearPreviousStep(threadInfo.getThread());
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(threadInfo.getThread(), -2, 2);
        Env.addExcludes(stepRequest);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void doKill(ThreadReference threadReference, StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No exception object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = this.evaluate(string);
        if (value != null && value instanceof ObjectReference) {
            try {
                threadReference.stop((ObjectReference)value);
                MessageOutput.println("killed", threadReference.toString());
            }
            catch (InvalidTypeException invalidTypeException) {
                MessageOutput.println("Invalid exception object");
            }
        } else {
            MessageOutput.println("Expression must evaluate to an object");
        }
    }

    void doKillThread(final ThreadReference threadReference, final StringTokenizer stringTokenizer) {
        new AsyncExecution(){

            void action() {
                Commands.this.doKill(threadReference, stringTokenizer);
            }
        };
    }

    void commandKill(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Usage: kill <thread id> <throwable>");
            return;
        }
        ThreadInfo threadInfo = this.doGetThread(stringTokenizer.nextToken());
        if (threadInfo != null) {
            MessageOutput.println("killing thread:", threadInfo.getThread().name());
            this.doKillThread(threadInfo.getThread(), stringTokenizer);
            return;
        }
    }

    void listCaughtExceptions() {
        boolean bl = true;
        for (EventRequestSpec eventRequestSpec : Env.specList.eventRequestSpecs()) {
            if (!(eventRequestSpec instanceof ExceptionSpec)) continue;
            if (bl) {
                bl = false;
                MessageOutput.println("Exceptions caught:");
            }
            MessageOutput.println("tab", eventRequestSpec.toString());
        }
        if (bl) {
            MessageOutput.println("No exceptions caught.");
        }
    }

    private EventRequestSpec parseExceptionSpec(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        boolean bl = false;
        boolean bl2 = false;
        EventRequestSpec eventRequestSpec = null;
        String string2 = null;
        if (string.equals("uncaught")) {
            bl = false;
            bl2 = true;
        } else if (string.equals("caught")) {
            bl = true;
            bl2 = false;
        } else if (string.equals("all")) {
            bl = true;
            bl2 = true;
        } else {
            bl = true;
            bl2 = true;
            string2 = string;
        }
        if (string2 == null && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2 != null && (bl || bl2)) {
            try {
                eventRequestSpec = Env.specList.createExceptionCatch(string2, bl, bl2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageOutput.println("is not a valid class name", string2);
            }
        }
        return eventRequestSpec;
    }

    void commandCatchException(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listCaughtExceptions();
        } else {
            EventRequestSpec eventRequestSpec = this.parseExceptionSpec(stringTokenizer);
            if (eventRequestSpec != null) {
                this.resolveNow(eventRequestSpec);
            } else {
                MessageOutput.println("Usage: catch exception");
            }
        }
    }

    void commandIgnoreException(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listCaughtExceptions();
        } else {
            EventRequestSpec eventRequestSpec = this.parseExceptionSpec(stringTokenizer);
            if (Env.specList.delete(eventRequestSpec)) {
                MessageOutput.println("Removed:", eventRequestSpec.toString());
            } else {
                if (eventRequestSpec != null) {
                    MessageOutput.println("Not found:", eventRequestSpec.toString());
                }
                MessageOutput.println("Usage: ignore exception");
            }
        }
    }

    void commandUp(StringTokenizer stringTokenizer) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setParseIntegerOnly(true);
                Number number = numberFormat.parse(string);
                n2 = number.intValue();
            }
            catch (ParseException parseException) {
                n2 = 0;
            }
            if (n2 <= 0) {
                MessageOutput.println("Usage: up [n frames]");
                return;
            }
            n = n2;
        }
        try {
            threadInfo.up(n);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Current thread isnt suspended.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            MessageOutput.println("End of stack.");
        }
    }

    void commandDown(StringTokenizer stringTokenizer) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setParseIntegerOnly(true);
                Number number = numberFormat.parse(string);
                n2 = number.intValue();
            }
            catch (ParseException parseException) {
                n2 = 0;
            }
            if (n2 <= 0) {
                MessageOutput.println("Usage: down [n frames]");
                return;
            }
            n = n2;
        }
        try {
            threadInfo.down(n);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Current thread isnt suspended.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            MessageOutput.println("End of stack.");
        }
    }

    private void dumpStack(ThreadInfo threadInfo, boolean bl) {
        List list = null;
        try {
            list = threadInfo.getStack();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Current thread isnt suspended.");
            return;
        }
        if (list == null) {
            MessageOutput.println("Thread is not running (no stack).");
        } else {
            int n = list.size();
            for (int i = threadInfo.getCurrentFrameIndex(); i < n; ++i) {
                StackFrame stackFrame = (StackFrame)list.get(i);
                this.dumpFrame(i, bl, stackFrame);
            }
        }
    }

    private void dumpFrame(int n, boolean bl, StackFrame stackFrame) {
        Location location = stackFrame.location();
        long l = -1L;
        if (bl) {
            l = location.codeIndex();
        }
        Method method = location.method();
        long l2 = location.lineNumber();
        String string = null;
        if (method instanceof Method && method.isNative()) {
            string = MessageOutput.format("native method");
        } else if (l2 != -1L) {
            try {
                string = location.sourceName() + MessageOutput.format("line number", new Object[]{new Long(l2)});
            }
            catch (AbsentInformationException absentInformationException) {
                string = MessageOutput.format("unknown");
            }
        }
        if (l != -1L) {
            MessageOutput.println("stack frame dump with pc", new Object[]{new Integer(n + 1), method.declaringType().name(), method.name(), string, new Long(l)});
        } else {
            MessageOutput.println("stack frame dump", new Object[]{new Integer(n + 1), method.declaringType().name(), method.name(), string});
        }
    }

    void commandWhere(StringTokenizer stringTokenizer, boolean bl) {
        if (!stringTokenizer.hasMoreTokens()) {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
            this.dumpStack(threadInfo, bl);
        } else {
            String string = stringTokenizer.nextToken();
            if (string.toLowerCase().equals("all")) {
                for (ThreadInfo threadInfo : ThreadInfo.threads()) {
                    MessageOutput.println("Thread:", threadInfo.getThread().name());
                    this.dumpStack(threadInfo, bl);
                }
            } else {
                ThreadInfo threadInfo = this.doGetThread(string);
                if (threadInfo != null) {
                    ThreadInfo.setCurrentThreadInfo(threadInfo);
                    this.dumpStack(threadInfo, bl);
                }
            }
        }
    }

    void commandInterrupt(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
            threadInfo.getThread().interrupt();
        } else {
            ThreadInfo threadInfo = this.doGetThread(stringTokenizer.nextToken());
            if (threadInfo != null) {
                threadInfo.getThread().interrupt();
            }
        }
    }

    void commandMemory() {
        MessageOutput.println("The memory command is no longer supported.");
    }

    void commandGC() {
        MessageOutput.println("The gc command is no longer necessary.");
    }

    static String locationString(Location location) {
        return MessageOutput.format("locationString", new Object[]{location.declaringType().name(), location.method().name(), new Integer(location.lineNumber()), new Long(location.codeIndex())});
    }

    void listBreakpoints() {
        boolean bl = true;
        for (EventRequestSpec eventRequestSpec : Env.specList.eventRequestSpecs()) {
            if (!(eventRequestSpec instanceof BreakpointSpec)) continue;
            if (bl) {
                bl = false;
                MessageOutput.println("Breakpoints set:");
            }
            MessageOutput.println("tab", eventRequestSpec.toString());
        }
        if (bl) {
            MessageOutput.println("No breakpoints set.");
        }
    }

    private void printBreakpointCommandUsage(String string, String string2) {
        MessageOutput.println("printbreakpointcommandusage", new Object[]{string, string2});
    }

    protected BreakpointSpec parseBreakpointSpec(StringTokenizer stringTokenizer, String string, String string2) {
        EventRequestSpec eventRequestSpec = null;
        try {
            String string3;
            String string4 = stringTokenizer.nextToken(":( \t\n\r");
            try {
                string3 = stringTokenizer.nextToken("").trim();
            }
            catch (NoSuchElementException noSuchElementException) {
                string3 = null;
            }
            if (string3 != null && string3.startsWith(":")) {
                stringTokenizer = new StringTokenizer(string3.substring(1));
                String string5 = string4;
                String string6 = stringTokenizer.nextToken();
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setParseIntegerOnly(true);
                Number number = numberFormat.parse(string6);
                int n = number.intValue();
                if (stringTokenizer.hasMoreTokens()) {
                    this.printBreakpointCommandUsage(string, string2);
                    return null;
                }
                try {
                    eventRequestSpec = Env.specList.createBreakpoint(string5, n);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageOutput.println("is not a valid class name", string5);
                }
            } else {
                int n = string4.lastIndexOf(".");
                if (n <= 0 || n >= string4.length() - 1) {
                    this.printBreakpointCommandUsage(string, string2);
                    return null;
                }
                String string7 = string4.substring(n + 1);
                String string8 = string4.substring(0, n);
                ArrayList<String> arrayList = null;
                if (string3 != null) {
                    if (!string3.startsWith("(") || !string3.endsWith(")")) {
                        MessageOutput.println("Invalid method specification:", string7 + string3);
                        this.printBreakpointCommandUsage(string, string2);
                        return null;
                    }
                    string3 = string3.substring(1, string3.length() - 1);
                    arrayList = new ArrayList<String>();
                    stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                }
                try {
                    eventRequestSpec = Env.specList.createBreakpoint(string8, string7, arrayList);
                }
                catch (MalformedMemberNameException malformedMemberNameException) {
                    MessageOutput.println("is not a valid method name", string7);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageOutput.println("is not a valid class name", string8);
                }
            }
        }
        catch (Exception exception) {
            this.printBreakpointCommandUsage(string, string2);
            return null;
        }
        return (BreakpointSpec)eventRequestSpec;
    }

    private void resolveNow(EventRequestSpec eventRequestSpec) {
        boolean bl = Env.specList.addEagerlyResolve(eventRequestSpec);
        if (bl && !eventRequestSpec.isResolved()) {
            MessageOutput.println("Deferring.", eventRequestSpec.toString());
        }
    }

    void commandStop(StringTokenizer stringTokenizer) {
        String string;
        int n = 2;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals("go") && stringTokenizer.hasMoreTokens()) {
                n = 0;
                string = stringTokenizer.nextToken();
            } else if (string.equals("thread") && stringTokenizer.hasMoreTokens()) {
                n = 1;
                string = stringTokenizer.nextToken();
            }
        } else {
            this.listBreakpoints();
            return;
        }
        BreakpointSpec breakpointSpec = this.parseBreakpointSpec(stringTokenizer, "stop at", "stop in");
        if (breakpointSpec != null) {
            if (string.equals("at") && breakpointSpec.isMethodBreakpoint()) {
                MessageOutput.println("Use stop at to set a breakpoint at a line number");
                this.printBreakpointCommandUsage("stop at", "stop in");
                return;
            }
            breakpointSpec.suspendPolicy = n;
            this.resolveNow(breakpointSpec);
        }
    }

    void commandClear(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listBreakpoints();
            return;
        }
        BreakpointSpec breakpointSpec = this.parseBreakpointSpec(stringTokenizer, "clear", "clear");
        if (breakpointSpec != null) {
            if (Env.specList.delete(breakpointSpec)) {
                MessageOutput.println("Removed:", breakpointSpec.toString());
            } else {
                MessageOutput.println("Not found:", breakpointSpec.toString());
            }
        }
    }

    private List parseWatchpointSpec(StringTokenizer stringTokenizer) {
        ArrayList<EventRequestSpec> arrayList = new ArrayList<EventRequestSpec>();
        boolean bl = false;
        boolean bl2 = false;
        int n = 2;
        String string = stringTokenizer.nextToken();
        if (string.equals("go")) {
            n = 0;
            string = stringTokenizer.nextToken();
        } else if (string.equals("thread")) {
            n = 1;
            string = stringTokenizer.nextToken();
        }
        if (string.equals("access")) {
            bl = true;
            string = stringTokenizer.nextToken();
        } else if (string.equals("all")) {
            bl = true;
            bl2 = true;
            string = stringTokenizer.nextToken();
        } else {
            bl2 = true;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            MessageOutput.println("Class containing field must be specified.");
            return arrayList;
        }
        String string2 = string.substring(0, n2);
        string = string.substring(n2 + 1);
        try {
            EventRequestSpec eventRequestSpec;
            if (bl) {
                eventRequestSpec = Env.specList.createAccessWatchpoint(string2, string);
                eventRequestSpec.suspendPolicy = n;
                arrayList.add(eventRequestSpec);
            }
            if (bl2) {
                eventRequestSpec = Env.specList.createModificationWatchpoint(string2, string);
                eventRequestSpec.suspendPolicy = n;
                arrayList.add(eventRequestSpec);
            }
        }
        catch (MalformedMemberNameException malformedMemberNameException) {
            MessageOutput.println("is not a valid field name", string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageOutput.println("is not a valid class name", string2);
        }
        return arrayList;
    }

    void commandWatch(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Field to watch not specified");
            return;
        }
        Iterator iterator = this.parseWatchpointSpec(stringTokenizer).iterator();
        while (iterator.hasNext()) {
            this.resolveNow((WatchpointSpec)iterator.next());
        }
    }

    void commandUnwatch(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Field to unwatch not specified");
            return;
        }
        for (WatchpointSpec watchpointSpec : this.parseWatchpointSpec(stringTokenizer)) {
            if (Env.specList.delete(watchpointSpec)) {
                MessageOutput.println("Removed:", watchpointSpec.toString());
                continue;
            }
            MessageOutput.println("Not found:", watchpointSpec.toString());
        }
    }

    void commandTrace(StringTokenizer stringTokenizer) {
        int n = 2;
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("go")) {
                n = 0;
                string = stringTokenizer.nextToken();
            } else if (string.equals("thread")) {
                n = 1;
                string = stringTokenizer.nextToken();
            }
            if (!string.equals("methods")) {
                MessageOutput.println("Specify kind for example methods");
            }
        }
        ThreadInfo threadInfo = null;
        if (stringTokenizer.hasMoreTokens()) {
            threadInfo = this.doGetThread(stringTokenizer.nextToken());
        }
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        MethodEntryRequest methodEntryRequest = eventRequestManager.createMethodEntryRequest();
        MethodExitRequest methodExitRequest = eventRequestManager.createMethodExitRequest();
        if (threadInfo != null) {
            methodEntryRequest.addThreadFilter(threadInfo.getThread());
            methodExitRequest.addThreadFilter(threadInfo.getThread());
        }
        Env.addExcludes(methodEntryRequest);
        Env.addExcludes(methodExitRequest);
        methodEntryRequest.setSuspendPolicy(n);
        methodExitRequest.setSuspendPolicy(n);
        methodEntryRequest.enable();
        methodExitRequest.enable();
    }

    void commandUntrace(StringTokenizer stringTokenizer) {
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        Iterator<EventRequest> iterator = eventRequestManager.methodEntryRequests().iterator();
        while (iterator.hasNext()) {
            ((EventRequest)iterator.next()).disable();
        }
        iterator = eventRequestManager.methodExitRequests().iterator();
        while (iterator.hasNext()) {
            iterator.next().disable();
        }
    }

    void commandList(StringTokenizer stringTokenizer) {
        StackFrame stackFrame = null;
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("No thread specified.");
            return;
        }
        try {
            stackFrame = threadInfo.getCurrentFrame();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Current thread isnt suspended.");
            return;
        }
        if (stackFrame == null) {
            MessageOutput.println("No frames on the current call stack");
            return;
        }
        Location location = stackFrame.location();
        if (location.method().isNative()) {
            MessageOutput.println("Current method is native");
            return;
        }
        String string = null;
        try {
            string = location.sourceName();
            ReferenceType referenceType = location.declaringType();
            int n = location.lineNumber();
            if (stringTokenizer.hasMoreTokens()) {
                Object object;
                String string2 = stringTokenizer.nextToken();
                try {
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    numberFormat.setParseIntegerOnly(true);
                    object = numberFormat.parse(string2);
                    n = ((Number)object).intValue();
                }
                catch (ParseException parseException) {
                    object = referenceType.methodsByName(string2);
                    if (object == null || object.size() == 0) {
                        MessageOutput.println("is not a valid line number or method name for", new Object[]{string2, referenceType.name()});
                        return;
                    }
                    if (object.size() > 1) {
                        MessageOutput.println("is an ambiguous method name in", new Object[]{string2, referenceType.name()});
                        return;
                    }
                    location = ((Method)object.get(0)).location();
                    n = location.lineNumber();
                }
            }
            int n2 = Math.max(n - 4, 1);
            int n3 = n2 + 9;
            if (n < 0) {
                MessageOutput.println("Line number information not available for");
            } else if (Env.sourceLine(location, n) == null) {
                MessageOutput.println("is an invalid line number for", new Object[]{new Integer(n), referenceType.name()});
            } else {
                String string3;
                for (int i = n2; i <= n3 && (string3 = Env.sourceLine(location, i)) != null; ++i) {
                    if (i == n) {
                        MessageOutput.println("source line number current line and line", new Object[]{new Integer(i), string3});
                        continue;
                    }
                    MessageOutput.println("source line number and line", new Object[]{new Integer(i), string3});
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            MessageOutput.println("No source information available for:", location.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageOutput.println("Source file not found:", string);
        }
        catch (IOException iOException) {
            MessageOutput.println("I/O exception occurred:", iOException.toString());
        }
    }

    void commandLines(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Specify class and method");
        } else {
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            try {
                ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
                if (referenceType != null) {
                    List<Location> list = null;
                    if (string2 == null) {
                        list = referenceType.allLineLocations();
                    } else {
                        List<Method> list2 = referenceType.allMethods();
                        Iterator<Method> object = list2.iterator();
                        while (object.hasNext()) {
                            Method method = object.next();
                            if (!method.name().equals(string2)) continue;
                            list = method.allLineLocations();
                        }
                        if (list == null) {
                            MessageOutput.println("is not a valid method name", string2);
                        }
                    }
                    for (Location location : list) {
                        MessageOutput.printDirectln(location.toString());
                    }
                } else {
                    MessageOutput.println("is not a valid id or class name", string);
                }
            }
            catch (AbsentInformationException absentInformationException) {
                MessageOutput.println("Line number information not available for", string);
            }
        }
    }

    void commandClasspath(StringTokenizer stringTokenizer) {
        if (Env.vm() instanceof PathSearchingVirtualMachine) {
            PathSearchingVirtualMachine pathSearchingVirtualMachine = (PathSearchingVirtualMachine)Env.vm();
            MessageOutput.println("base directory:", pathSearchingVirtualMachine.baseDirectory());
            MessageOutput.println("classpath:", pathSearchingVirtualMachine.classPath().toString());
            MessageOutput.println("bootclasspath:", pathSearchingVirtualMachine.bootClassPath().toString());
        } else {
            MessageOutput.println("The VM does not use paths");
        }
    }

    void commandUse(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.printDirectln(Env.getSourcePath());
        } else {
            Env.setSourcePath(stringTokenizer.nextToken("").trim());
        }
    }

    private void printVar(LocalVariable localVariable, Value value) {
        MessageOutput.println("expr is value", new Object[]{localVariable.name(), value == null ? "null" : value.toString()});
    }

    void commandLocals() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("No default thread specified:");
            return;
        }
        try {
            Value value;
            StackFrame stackFrame = threadInfo.getCurrentFrame();
            if (stackFrame == null) {
                throw new AbsentInformationException();
            }
            List<LocalVariable> list = stackFrame.visibleVariables();
            if (list.size() == 0) {
                MessageOutput.println("No local variables");
                return;
            }
            Map<LocalVariable, Value> map = stackFrame.getValues(list);
            MessageOutput.println("Method arguments:");
            for (LocalVariable localVariable : list) {
                if (!localVariable.isArgument()) continue;
                value = map.get(localVariable);
                this.printVar(localVariable, value);
            }
            MessageOutput.println("Local variables:");
            for (LocalVariable localVariable : list) {
                if (localVariable.isArgument()) continue;
                value = map.get(localVariable);
                this.printVar(localVariable, value);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            MessageOutput.println("Local variable information not available.");
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Current thread isnt suspended.");
        }
    }

    private void dump(ObjectReference objectReference, ReferenceType referenceType, ReferenceType referenceType2) {
        Object object;
        Object object2 = referenceType.fields().iterator();
        while (object2.hasNext()) {
            object = new StringBuffer();
            Field field = object2.next();
            ((StringBuffer)object).append("    ");
            if (!((Object)referenceType).equals(referenceType2)) {
                ((StringBuffer)object).append(referenceType.name());
                ((StringBuffer)object).append(".");
            }
            ((StringBuffer)object).append(field.name());
            ((StringBuffer)object).append(MessageOutput.format("colon space"));
            ((StringBuffer)object).append(objectReference.getValue(field));
            MessageOutput.printDirectln(((StringBuffer)object).toString());
        }
        if (referenceType instanceof ClassType) {
            object2 = ((ClassType)referenceType).superclass();
            if (object2 != null) {
                this.dump(objectReference, (ReferenceType)object2, referenceType2);
            }
        } else if (referenceType instanceof InterfaceType) {
            object2 = ((InterfaceType)referenceType).superinterfaces();
            object = object2.iterator();
            while (object.hasNext()) {
                this.dump(objectReference, (ReferenceType)object.next(), referenceType2);
            }
        } else if (objectReference instanceof ArrayReference) {
            object2 = ((ArrayReference)objectReference).getValues().iterator();
            while (object2.hasNext()) {
                MessageOutput.printDirect(object2.next().toString());
                if (!object2.hasNext()) continue;
                MessageOutput.printDirect(", ");
            }
            MessageOutput.println();
        }
    }

    void doPrint(StringTokenizer stringTokenizer, boolean bl) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No objects specified.");
            return;
        }
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string = stringTokenizer.nextToken("");
            Value value = this.evaluate(string);
            if (value == null) {
                MessageOutput.println("expr is null", string.toString());
                continue;
            }
            if (bl && value instanceof ObjectReference && !(value instanceof StringReference)) {
                object = (ObjectReference)value;
                ReferenceType referenceType = object.referenceType();
                MessageOutput.println("expr is value", new Object[]{string.toString(), MessageOutput.format("grouping begin character")});
                this.dump((ObjectReference)object, referenceType, referenceType);
                MessageOutput.println("grouping end character");
                continue;
            }
            object = this.getStringValue();
            if (object == null) continue;
            MessageOutput.println("expr is value", new Object[]{string.toString(), object});
        }
    }

    void commandPrint(final StringTokenizer stringTokenizer, final boolean bl) {
        new AsyncExecution(){

            void action() {
                Commands.this.doPrint(stringTokenizer, bl);
            }
        };
    }

    void commandSet(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken("");
        if (string.indexOf(61) == -1) {
            MessageOutput.println("Invalid assignment syntax");
            MessageOutput.printPrompt();
            return;
        }
        this.commandPrint(new StringTokenizer(string), false);
    }

    void doLock(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = this.evaluate(string);
        try {
            if (value != null && value instanceof ObjectReference) {
                ThreadReference threadReference;
                ObjectReference objectReference = (ObjectReference)value;
                String string2 = this.getStringValue();
                if (string2 != null) {
                    MessageOutput.println("Monitor information for expr", new Object[]{string.trim(), string2});
                }
                if ((threadReference = objectReference.owningThread()) == null) {
                    MessageOutput.println("Not owned");
                } else {
                    MessageOutput.println("Owned by:", new Object[]{threadReference.name(), new Integer(objectReference.entryCount())});
                }
                List<ThreadReference> list = objectReference.waitingThreads();
                if (list.size() == 0) {
                    MessageOutput.println("No waiters");
                } else {
                    for (ThreadReference threadReference2 : list) {
                        MessageOutput.println("Waiting thread:", threadReference2.name());
                    }
                }
            } else {
                MessageOutput.println("Expression must evaluate to an object");
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Threads must be suspended");
        }
    }

    void commandLock(final StringTokenizer stringTokenizer) {
        new AsyncExecution(){

            void action() {
                Commands.this.doLock(stringTokenizer);
            }
        };
    }

    private void printThreadLockInfo(ThreadInfo threadInfo) {
        ThreadReference threadReference = threadInfo.getThread();
        try {
            MessageOutput.println("Monitor information for thread", threadReference.name());
            List<ObjectReference> list = threadReference.ownedMonitors();
            if (list.size() == 0) {
                MessageOutput.println("No monitors owned");
            } else {
                for (ObjectReference objectReference : list) {
                    MessageOutput.println("Owned monitor:", objectReference.toString());
                }
            }
            ObjectReference objectReference = threadReference.currentContendedMonitor();
            if (objectReference == null) {
                MessageOutput.println("Not waiting for a monitor");
            } else {
                MessageOutput.println("Waiting for monitor:", objectReference.toString());
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Threads must be suspended");
        }
    }

    void commandThreadlocks(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("Current thread not set.");
            } else {
                this.printThreadLockInfo(threadInfo);
            }
            return;
        }
        String string = stringTokenizer.nextToken();
        if (string.toLowerCase().equals("all")) {
            for (ThreadInfo threadInfo : ThreadInfo.threads()) {
                this.printThreadLockInfo(threadInfo);
            }
        } else {
            ThreadInfo threadInfo = this.doGetThread(string);
            if (threadInfo != null) {
                ThreadInfo.setCurrentThreadInfo(threadInfo);
                this.printThreadLockInfo(threadInfo);
            }
        }
    }

    void doDisableGC(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = this.evaluate(string);
        if (value != null && value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            objectReference.disableCollection();
            String string2 = this.getStringValue();
            if (string2 != null) {
                MessageOutput.println("GC Disabled for", string2);
            }
        } else {
            MessageOutput.println("Expression must evaluate to an object");
        }
    }

    void commandDisableGC(final StringTokenizer stringTokenizer) {
        new AsyncExecution(){

            void action() {
                Commands.this.doDisableGC(stringTokenizer);
            }
        };
    }

    void doEnableGC(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = this.evaluate(string);
        if (value != null && value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            objectReference.enableCollection();
            String string2 = this.getStringValue();
            if (string2 != null) {
                MessageOutput.println("GC Enabled for", string2);
            }
        } else {
            MessageOutput.println("Expression must evaluate to an object");
        }
    }

    void commandEnableGC(final StringTokenizer stringTokenizer) {
        new AsyncExecution(){

            void action() {
                Commands.this.doEnableGC(stringTokenizer);
            }
        };
    }

    void doSave(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No save index specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No expression specified.");
            return;
        }
        String string2 = stringTokenizer.nextToken("");
        Value value = this.evaluate(string2);
        if (value != null) {
            Env.setSavedValue(string, value);
            String string3 = this.getStringValue();
            if (string3 != null) {
                MessageOutput.println("saved", string3);
            }
        } else {
            MessageOutput.println("Expression cannot be void");
        }
    }

    void commandSave(final StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            Set set = Env.getSaveKeys();
            Iterator iterator = set.iterator();
            if (!iterator.hasNext()) {
                MessageOutput.println("No saved values");
                return;
            }
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Value value = Env.getSavedValue(string);
                if (value instanceof ObjectReference && ((ObjectReference)value).isCollected()) {
                    MessageOutput.println("expr is value <collected>", new Object[]{string, value.toString()});
                    continue;
                }
                if (value == null) {
                    MessageOutput.println("expr is null", string);
                    continue;
                }
                MessageOutput.println("expr is value", new Object[]{string, value.toString()});
            }
        } else {
            new AsyncExecution(){

                void action() {
                    Commands.this.doSave(stringTokenizer);
                }
            };
        }
    }

    void commandBytecodes(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No method specified.");
            return;
        }
        String string2 = stringTokenizer.nextToken();
        List<ReferenceType> list = Env.vm().classesByName(string);
        if (list.size() == 0) {
            if (string.indexOf(46) < 0) {
                MessageOutput.println("not found (try the full name)", string);
            } else {
                MessageOutput.println("not found", string);
            }
            return;
        }
        ReferenceType referenceType = list.get(0);
        if (!(referenceType instanceof ClassType)) {
            MessageOutput.println("not a class", string);
            return;
        }
        byte[] byArray = null;
        List<Method> list2 = referenceType.methodsByName(string2);
        for (Method comparable2 : list2) {
            if (comparable2.isAbstract()) continue;
            byArray = comparable2.bytecodes();
            break;
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("0000: ");
        for (int i = 0; i < byArray.length; ++i) {
            String j;
            int n;
            if (i > 0 && i % 16 == 0) {
                MessageOutput.printDirectln(stringBuffer.toString());
                stringBuffer.setLength(0);
                stringBuffer.append(String.valueOf(i));
                stringBuffer.append(": ");
                n = stringBuffer.length();
                for (int k = 0; k < 6 - n; ++k) {
                    stringBuffer.insert(0, '0');
                }
            }
            if ((j = Integer.toHexString(n = 0xFF & byArray[i])).length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(j);
            stringBuffer.append(' ');
        }
        if (stringBuffer.length() > 6) {
            MessageOutput.printDirectln(stringBuffer.toString());
        }
    }

    void commandExclude(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.printDirectln(Env.excludesString());
        } else {
            String string = stringTokenizer.nextToken("");
            if (string.equals("none")) {
                string = "";
            }
            Env.setExcludes(string);
        }
    }

    void commandRedefine(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Specify classes to redefine");
        } else {
            Object object;
            String string = stringTokenizer.nextToken();
            List<ReferenceType> list = Env.vm().classesByName(string);
            if (list.size() == 0) {
                MessageOutput.println("No class named", string);
                return;
            }
            if (list.size() > 1) {
                MessageOutput.println("More than one class named", string);
                return;
            }
            Env.setSourcePath(Env.getSourcePath());
            ReferenceType referenceType = list.get(0);
            if (!stringTokenizer.hasMoreTokens()) {
                MessageOutput.println("Specify file name for class", string);
                return;
            }
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            byte[] byArray = new byte[(int)file.length()];
            try {
                object = new FileInputStream(file);
                ((InputStream)object).read(byArray);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                MessageOutput.println("Error reading file", new Object[]{string2, exception.toString()});
                return;
            }
            object = new HashMap();
            object.put(referenceType, byArray);
            try {
                Env.vm().redefineClasses((Map<? extends ReferenceType, byte[]>)object);
            }
            catch (Throwable throwable) {
                MessageOutput.println("Error redefining class to file", new Object[]{string, string2, throwable});
            }
        }
    }

    void commandPopFrames(StringTokenizer stringTokenizer, boolean bl) {
        ThreadInfo threadInfo;
        Object object;
        if (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            threadInfo = this.doGetThread((String)object);
            if (threadInfo == null) {
                return;
            }
        } else {
            threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
        }
        try {
            object = threadInfo.getCurrentFrame();
            threadInfo.getThread().popFrames((StackFrame)object);
            threadInfo = ThreadInfo.getCurrentThreadInfo();
            ThreadInfo.setCurrentThreadInfo(threadInfo);
            if (bl) {
                this.commandStepi();
            }
        }
        catch (Throwable throwable) {
            MessageOutput.println("Error popping frame", throwable.toString());
        }
    }

    void commandExtension(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
        String string2 = null;
        if (referenceType != null) {
            try {
                string2 = referenceType.sourceDebugExtension();
                MessageOutput.println("sourcedebugextension", string2);
            }
            catch (AbsentInformationException absentInformationException) {
                MessageOutput.println("No sourcedebugextension specified");
            }
        } else {
            MessageOutput.println("is not a valid id or class name", string);
        }
    }

    void commandVersion(String string, VirtualMachineManager virtualMachineManager) {
        MessageOutput.println("minus version", new Object[]{string, new Integer(virtualMachineManager.majorInterfaceVersion()), new Integer(virtualMachineManager.minorInterfaceVersion()), System.getProperty("java.version")});
        if (Env.connection() != null) {
            try {
                MessageOutput.printDirectln(Env.vm().description());
            }
            catch (VMNotConnectedException vMNotConnectedException) {
                MessageOutput.println("No VM connected");
            }
        }
    }

    abstract class AsyncExecution {
        abstract void action();

        AsyncExecution() {
            this.execute();
        }

        void execute() {
            final ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            final int n = threadInfo == null ? 0 : threadInfo.getCurrentFrameIndex();
            Thread thread = new Thread("asynchronous jdb command"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block23: {
                        block19: {
                            AsyncExecution.this.action();
                            if (threadInfo == null) break block19;
                            ThreadInfo.setCurrentThreadInfo(threadInfo);
                            try {
                                threadInfo.setCurrentFrameIndex(n);
                            }
                            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                                MessageOutput.println("Current thread isnt suspended.");
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(n)});
                            }
                        }
                        MessageOutput.printPrompt();
                        break block23;
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            block20: {
                                MessageOutput.println("Operation is not supported on the target VM");
                                if (threadInfo == null) break block20;
                                ThreadInfo.setCurrentThreadInfo(threadInfo);
                                try {
                                    threadInfo.setCurrentFrameIndex(n);
                                }
                                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                                    MessageOutput.println("Current thread isnt suspended.");
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(n)});
                                }
                            }
                            MessageOutput.printPrompt();
                        }
                        catch (Exception exception) {
                            block21: {
                                MessageOutput.println("Internal exception during operation:", exception.getMessage());
                                if (threadInfo == null) break block21;
                                {
                                    catch (Throwable throwable) {
                                        if (threadInfo != null) {
                                            ThreadInfo.setCurrentThreadInfo(threadInfo);
                                            try {
                                                threadInfo.setCurrentFrameIndex(n);
                                            }
                                            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                                                MessageOutput.println("Current thread isnt suspended.");
                                            }
                                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                                MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(n)});
                                            }
                                        }
                                        MessageOutput.printPrompt();
                                        throw throwable;
                                    }
                                }
                                ThreadInfo.setCurrentThreadInfo(threadInfo);
                                try {
                                    threadInfo.setCurrentFrameIndex(n);
                                }
                                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                                    MessageOutput.println("Current thread isnt suspended.");
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(n)});
                                }
                            }
                            MessageOutput.printPrompt();
                        }
                    }
                }
            };
            thread.start();
        }
    }
}

