/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.boxes.impl;

import java.io.IOException;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.boxes.FullBox;

public class EditListBox
extends FullBox {
    private long[] segmentDuration;
    private long[] mediaTime;
    private double[] mediaRate;

    public EditListBox() {
        super("Edit List Box");
    }

    public void decode(MP4InputStream in) throws IOException {
        super.decode(in);
        int entryCount = (int)in.readBytes(4);
        int len = this.version == 1 ? 8 : 4;
        this.segmentDuration = new long[entryCount];
        this.mediaTime = new long[entryCount];
        this.mediaRate = new double[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            this.segmentDuration[i] = in.readBytes(len);
            this.mediaTime[i] = in.readBytes(len);
            this.mediaRate[i] = in.readFixedPoint(16, 16);
        }
    }

    public long[] getSegmentDuration() {
        return this.segmentDuration;
    }

    public long[] getMediaTime() {
        return this.mediaTime;
    }

    public double[] getMediaRate() {
        return this.mediaRate;
    }
}

