/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.main;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Map;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Player;
import org.muplayer.audio.Track;
import org.muplayer.audio.model.SeekOption;
import org.muplayer.main.ConsoleOrder;
import org.muplayer.system.Command;
import org.muplayer.system.CommandInterpreter;
import org.muplayer.system.SysInfo;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public class ConsoleInterpreter
implements CommandInterpreter {
    private Player player;
    private final File playerFolder;
    private boolean on;
    private static final String CMD_DIVISOR = " && ";

    public ConsoleInterpreter(Player player) {
        this.player = player;
        this.playerFolder = player.getRootFolder();
        this.on = false;
    }

    private boolean isPlayerOn() {
        return this.player != null && this.player.isAlive();
    }

    private void execSysCommand(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            if (process.exitValue() == 0) {
                this.printStreamOut(process.getInputStream());
            } else {
                this.printStreamOut(process.getErrorStream());
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.getLogger(this, (Object)e.getMessage()).error();
        }
    }

    protected void printStreamOut(InputStream cmdStream) throws IOException {
        int read;
        FileOutputStream stdout = SystemUtil.getStdout();
        while ((read = cmdStream.read()) != -1) {
            stdout.write(read);
        }
    }

    protected void clearConsole() throws IOException {
        Process process = SysInfo.ISUNIX ? Runtime.getRuntime().exec("clear") : Runtime.getRuntime().exec("cls");
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (process.exitValue() == 0) {
            this.printStreamOut(process.getInputStream());
        } else {
            this.printStreamOut(process.getErrorStream());
        }
    }

    protected void printHelp() {
        Map<String, String> helpMap = ConsoleOrder.HELP_MAP;
        Iterator<Map.Entry<String, String>> it = helpMap.entrySet().iterator();
        StringBuilder sbHelp = new StringBuilder();
        int count = 1;
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            sbHelp.append(count).append(") ").append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
            ++count;
        }
        Logger.getLogger(this, (Object)"---------").rawWarning();
        Logger.getLogger(this, (Object)"Help Info").rawWarning();
        Logger.getLogger(this, (Object)"---------").rawWarning();
        Logger.getLogger(this, (Object)sbHelp.toString()).rawWarning();
    }

    public void showSongInfo(Track current) {
        current = this.player.getCurrent();
        if (current == null) {
            Logger.getLogger(this, (Object)"Current track unavailable").rawError();
        } else {
            Logger.getLogger(this, (Object)current.getSongInfo()).rawWarning();
        }
    }

    public void preInterprate(String cmd) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        if (cmd.contains(CMD_DIVISOR)) {
            String[] cmdSplit = cmd.split(CMD_DIVISOR);
            for (int i = 0; i < cmdSplit.length; ++i) {
                this.interprate(cmdSplit[i].trim());
            }
        } else {
            this.interprate(cmd);
        }
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    @Override
    public void interprate(Command cmd) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        String cmdOrder;
        switch (cmdOrder = cmd.getOrder()) {
            case "st": {
                if (this.player == null) {
                    this.player = new Player(this.playerFolder);
                }
                if (this.player.isAlive() && cmd.hasOptions()) {
                    File musicFolder = new File(cmd.getOptionAt(0));
                    if (musicFolder.exists()) {
                        Player newPlayer = new Player(musicFolder);
                        this.player.shutdown();
                        newPlayer.start();
                        this.player = newPlayer;
                    } else {
                        Logger.getLogger(this, (Object)"Folder not exists").rawError();
                    }
                } else if (!this.player.isAlive()) {
                    this.player.start();
                }
                if (this.player.getCurrent() == null) break;
                this.showSongInfo(this.player.getCurrent());
                break;
            }
            case "ist": {
                Logger.getLogger(this, (Object)(this.isPlayerOn() ? "Is playing" : "Is not playing")).rawWarning();
                break;
            }
            case "pl": {
                if (!this.isPlayerOn()) break;
                if (cmd.hasOptions()) {
                    Number playIndex = cmd.getOptionAsNumber(0);
                    if (playIndex != null && playIndex.intValue() > 0 && playIndex.intValue() <= this.player.getSongsCount()) {
                        this.player.play(playIndex.intValue() - 1);
                    }
                    this.showSongInfo(this.player.getCurrent());
                    break;
                }
                this.player.play();
                break;
            }
            case "ps": {
                if (!this.isPlayerOn()) break;
                this.player.pause();
                break;
            }
            case "s": {
                if (!this.isPlayerOn()) break;
                this.player.stopTrack();
                break;
            }
            case "r": {
                if (!this.isPlayerOn()) break;
                this.player.resumeTrack();
                break;
            }
            case "n": {
                if (this.isPlayerOn()) {
                    if (cmd.hasOptions()) {
                        Number jumps = cmd.getOptionAsNumber(0);
                        if (jumps == null) {
                            Logger.getLogger(this, (Object)"Jump value incorrect").rawError();
                        } else {
                            this.player.jumpTrack(jumps.intValue(), SeekOption.NEXT);
                        }
                    } else {
                        this.player.playNext();
                    }
                }
                this.showSongInfo(this.player.getCurrent());
                break;
            }
            case "p": {
                if (!this.isPlayerOn()) break;
                if (cmd.hasOptions()) {
                    Number jumps = cmd.getOptionAsNumber(0);
                    if (jumps == null) {
                        Logger.getLogger(this, (Object)"Jump value incorrect").rawError();
                    } else {
                        this.player.jumpTrack(jumps.intValue(), SeekOption.PREV);
                    }
                } else {
                    this.player.playPrevious();
                }
                this.showSongInfo(this.player.getCurrent());
                break;
            }
            case "m": {
                if (!this.isPlayerOn()) break;
                this.player.mute();
                break;
            }
            case "um": {
                if (!this.isPlayerOn()) break;
                this.player.unmute();
                break;
            }
            case "l": 
            case "list": {
                if (this.player == null) break;
                this.player.printTracks();
                break;
            }
            case "lc": {
                if (!this.isPlayerOn()) break;
                this.player.printFolderTracks();
                break;
            }
            case "lf": {
                if (!this.isPlayerOn()) break;
                this.player.printFolders();
                break;
            }
            case "gv": {
                if (this.player == null) break;
                Logger.getLogger(this, (Object)("Player Volume(0-100): " + this.player.getGain())).rawWarning();
                break;
            }
            case "v": {
                if (this.player == null || !cmd.hasOptions()) break;
                Number volume = cmd.getOptionAsNumber(0);
                if (volume == null) {
                    Logger.getLogger(this, (Object)"Volume value incorrect").rawError();
                    break;
                }
                this.player.setGain(volume.floatValue());
                Logger.getLogger(this, (Object)"Volume value changed").rawWarning();
                break;
            }
            case "gsv": {
                if (this.player == null) break;
                Logger.getLogger(this, (Object)("Player Volume(0-100): " + this.player.getSystemVolume())).rawWarning();
                break;
            }
            case "sv": {
                if (this.player == null || !cmd.hasOptions()) break;
                Number volume = cmd.getOptionAsNumber(0);
                if (volume == null) {
                    Logger.getLogger(this, (Object)"Volume value incorrect").rawError();
                    break;
                }
                this.player.setSystemVolume(volume.floatValue());
                Logger.getLogger(this, (Object)"Volume value changed").rawWarning();
                break;
            }
            case "sh": {
                if (!this.isPlayerOn()) break;
                this.player.shutdown();
                this.player = null;
                break;
            }
            case "exit": 
            case "quit": {
                if (this.isPlayerOn()) {
                    this.player.shutdown();
                    this.player = null;
                }
                this.on = false;
                break;
            }
            case "k": {
                if (!this.isPlayerOn() || !cmd.hasOptions()) break;
                Number seekSec = cmd.getOptionAsNumber(0);
                if (seekSec == null) {
                    Logger.getLogger(this, (Object)"Seek value incorrect").rawError();
                    break;
                }
                this.player.seek(seekSec.doubleValue());
                Logger.getLogger(this, (Object)"Seeked").rawWarning();
                break;
            }
            case "skf": {
                if (!this.isPlayerOn()) break;
                if (cmd.hasOptions()) {
                    String optionParam = cmd.getOptionAt(0);
                    SeekOption option = optionParam.equals("next") ? SeekOption.NEXT : (optionParam.equals("prev") ? SeekOption.PREV : null);
                    Number jumps = cmd.getOptionAsNumber(1);
                    if (cmd.getOptionsCount() > 1 && jumps == null) {
                        Logger.getLogger(this, (Object)"Seek value incorrect").rawError();
                    } else if (jumps == null && option == null) {
                        Logger.getLogger(this, (Object)"Option value incorrect").rawError();
                    } else if (jumps == null) {
                        this.player.seekFolder(option);
                    } else if (jumps.intValue() < 0) {
                        Logger.getLogger(this, (Object)"Jumps value incorrect").rawError();
                    } else {
                        this.player.seekFolder(option, jumps.intValue());
                        Logger.getLogger(this, (Object)"Seeked").rawWarning();
                    }
                } else {
                    this.player.seekFolder(SeekOption.NEXT);
                }
                this.showSongInfo(this.player.getCurrent());
                break;
            }
            case "u": {
                if (this.player == null) break;
                this.player.reloadTracks();
                break;
            }
            case "g": {
                if (this.player == null || !cmd.hasOptions()) break;
                Number gotoSec = cmd.getOptionAsNumber(0);
                if (gotoSec == null) {
                    Logger.getLogger(this, (Object)"Go to value incorrect").rawError();
                    break;
                }
                this.player.gotoSecond(gotoSec.doubleValue());
                break;
            }
            case "c": {
                System.out.println("in soundcount option");
                int count = this.player.getSongsCount();
                System.out.println("SoundCount: " + count);
                if (this.player == null) break;
                Logger.getLogger(this, (Object)count).info();
                break;
            }
            case "d": {
                if (this.player == null) break;
                Logger.getLogger(this, (Object)this.player.getCurrent().getFormattedDuration()).info();
                break;
            }
            case "cover": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                    break;
                }
                if (!current.hasCover()) {
                    Logger.getLogger(this, (Object)"Current song don't have cover").rawError();
                    break;
                }
                if (cmd.hasOptions()) {
                    File folderPath = new File(cmd.getOptionAt(0));
                    if (!folderPath.exists()) {
                        folderPath = this.player.getRootFolder();
                    }
                    File fileCover = new File(folderPath, "cover-" + current.getTitle() + ".png");
                    fileCover.createNewFile();
                    Files.write(fileCover.toPath(), current.getCoverData(), StandardOpenOption.WRITE);
                    Logger.getLogger(this, (Object)("Created cover with name " + fileCover.getName())).rawWarning();
                    break;
                }
                Logger.getLogger(this, (Object)"Cover path not defined").rawError();
                break;
            }
            case "info": {
                this.showSongInfo(this.player.getCurrent());
                break;
            }
            case "prog": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                    break;
                }
                if (cmd.hasOptions()) {
                    if (!cmd.getOptionAt(0).equals("h")) break;
                    Logger.getLogger(this, (Object)current.getFormattedProgress()).rawWarning();
                    break;
                }
                Logger.getLogger(this, (Object)current.getProgress()).rawWarning();
                break;
            }
            case "clear": 
            case "cls": {
                this.clearConsole();
                break;
            }
            case "format": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                    break;
                }
                String className = current.getClass().getSimpleName();
                Logger.getLogger(this, (Object)className.substring(0, className.length() - 5).toLowerCase()).rawWarning();
                break;
            }
            case "title": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                    break;
                }
                Logger.getLogger(this, (Object)current.getTitle()).rawWarning();
                break;
            }
            case "name": {
                Track current = this.player.getCurrent();
                if (current == null) {
                    Logger.getLogger(this, (Object)"Current track unavailable").rawError();
                    break;
                }
                Logger.getLogger(this, (Object)current.getDataSource().getName()).rawWarning();
                break;
            }
            case "h": 
            case "help": {
                this.printHelp();
                break;
            }
            case "system": 
            case "sys": {
                if (!cmd.hasOptions()) break;
                this.execSysCommand(cmd.getOptionsAsString());
                break;
            }
            case "sn": {
                if (!this.isPlayerOn()) break;
                Track next = (Track)this.player.getNext();
                System.out.println(next.getSongInfo());
                break;
            }
            case "sp": {
                if (!this.isPlayerOn()) break;
                Track prev = (Track)this.player.getPrevious();
                System.out.println(prev.getSongInfo());
                break;
            }
            case "pf": {
                Number fldIndex;
                if (!this.isPlayerOn() || !cmd.hasOptions() || (fldIndex = cmd.getOptionAsNumber(0)) == null) break;
                this.player.playFolder(fldIndex.intValue() - 1);
                break;
            }
            case "load": {
                if (!cmd.hasOptions()) break;
                File folder = new File(cmd.getOptionAt(0));
                if (folder.exists()) {
                    if (folder.isDirectory()) {
                        if (folder.list() == null) {
                            Logger.getLogger(this, (Object)"Folder is empty").rawError();
                            break;
                        }
                        Player newPlayer = new Player(folder);
                        newPlayer.start();
                        if (this.isPlayerOn()) {
                            this.player.shutdown();
                        }
                        this.player = newPlayer;
                        break;
                    }
                    Logger.getLogger(this, (Object)"Path not be a directory").rawError();
                    break;
                }
                Logger.getLogger(this, (Object)"Folder not exists").rawError();
                break;
            }
            default: {
                Logger.getLogger(this, (Object)"Comando desconocido, inserte el comando \"h\" o \"help\"\npara desplegar el men\u00fa de ayuda.").rawWarning();
            }
        }
    }
}

