/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import org.jflac.FLACDecoder;
import org.jflac.PCMProcessor;
import org.jflac.metadata.StreamInfo;
import org.jflac.util.ByteData;
import org.jflac.util.WavWriter;

public class FlacDecoder
implements PCMProcessor {
    private WavWriter wav;
    private AudioInputStream decodedAis;
    private FileInputStream inputFile;
    private ByteArrayOutputStream outStream;
    private ByteArrayInputStream audioIn;
    private StreamInfo flacInfo;

    public FlacDecoder(File inFile) throws FileNotFoundException {
        this.inputFile = new FileInputStream(inFile);
        this.outStream = new ByteArrayOutputStream();
        this.wav = new WavWriter(this.outStream);
    }

    public boolean isFlac() {
        try {
            FLACDecoder decoder = new FLACDecoder(this.inputFile);
            decoder.addPCMProcessor(this);
            decoder.decode();
            this.audioIn = new ByteArrayInputStream(this.outStream.toByteArray());
            this.flacInfo = decoder.getStreamInfo();
            return this.flacInfo != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public StreamInfo getFlacInfo() {
        return this.flacInfo;
    }

    public AudioInputStream getDecodedStream() {
        return this.decodedAis;
    }

    public void decode() {
        if (this.flacInfo != null) {
            this.decodedAis = new AudioInputStream(this.audioIn, this.flacInfo.getAudioFormat(), this.audioIn.available());
        }
    }

    @Override
    public void processStreamInfo(StreamInfo info) {
        try {
            this.wav.writeHeader(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processPCM(ByteData pcm) {
        try {
            this.wav.writePCM(pcm);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

