/*
 * Decompiled with CFR 0.152.
 */
package org.aucom.io;

import java.io.IOException;
import java.io.InputStream;
import org.bytebuffer.ByteBuffer;

public class ElectroInputStream
extends InputStream {
    private final ByteBuffer buffer = new ByteBuffer(10240);
    private int pos = 0;
    private int readLimit = 0;
    private boolean isMarked = false;

    public ByteBuffer getListBytes() {
        return this.buffer;
    }

    void addBytes(byte b) {
        this.buffer.add(b);
    }

    public void clear() {
        this.buffer.clear();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.size() - this.pos;
    }

    public boolean hasBytes() {
        return !this.buffer.isEmpty();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        System.out.println("Pos: " + this.pos);
        if (!this.hasBytes()) {
            return -1;
        }
        if (len > b.length) {
            len = b.length;
        }
        if (len > this.available()) {
            len = this.available();
        }
        int readLen = this.isMarked && this.readLimit < len ? this.readLimit : len;
        System.out.println("ReadLen: " + readLen);
        int read = this.buffer.read(b, off, readLen);
        if (read == -2) {
            this.pos = 0;
        }
        this.buffer.removeAt(0, len);
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.read(b, 0, b.length);
        return read;
    }

    @Override
    public int read() throws IOException {
        if (this.isMarked && this.readLimit == 0) {
            return -1;
        }
        return this.buffer.isEmpty() ? -1 : (int)this.buffer.pollFirst();
    }

    public byte[] read(int len) throws IOException {
        if (this.available() == 0) {
            return null;
        }
        if (len > this.available()) {
            len = this.available();
        }
        byte[] b = new byte[len];
        this.read(b);
        this.skip(len);
        return b;
    }

    @Override
    public byte[] readAllBytes() {
        return this.buffer.toArray();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.pos = 0;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.readLimit = readlimit;
        this.isMarked = true;
    }

    @Override
    public void close() throws IOException {
        this.pos = this.buffer.size();
        this.readLimit = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        this.pos = (int)((long)this.pos + n);
        return n;
    }
}

