/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.aucom.sound.Speaker;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.TagException;
import org.muplayer.audio.Player;
import org.muplayer.audio.formats.FlacTrack;
import org.muplayer.audio.formats.M4ATrack;
import org.muplayer.audio.formats.MP3Track;
import org.muplayer.audio.formats.OGGTrack;
import org.muplayer.audio.formats.PCMTrack;
import org.muplayer.audio.info.AudioTag;
import org.muplayer.audio.interfaces.MusicControls;
import org.muplayer.audio.model.TrackInfo;
import org.muplayer.audio.util.TimeFormatter;
import org.muplayer.system.AudioUtil;
import org.muplayer.thread.PlayerHandler;
import org.muplayer.thread.TPlayingTrack;
import org.orangelogger.sys.Logger;

public abstract class Track
extends Thread
implements MusicControls,
TrackInfo {
    protected volatile File dataSource;
    protected volatile Speaker trackLine;
    protected volatile AudioInputStream trackStream;
    protected volatile AudioFileReader audioReader;
    protected volatile AudioTag tagInfo;
    protected volatile byte state;
    protected volatile double secsSeeked;
    protected volatile double bytesPerSecond;
    protected volatile float volume;
    protected volatile boolean isMute;
    protected Object source;
    public static final int BUFFSIZE = 4096;

    public static Track getTrack(File fSound) {
        if (!fSound.exists()) {
            return null;
        }
        Track result = null;
        String trackName = fSound.getName();
        try {
            if (trackName.endsWith(".mp3")) {
                result = new MP3Track(fSound);
            } else if (trackName.endsWith(".ogg")) {
                result = new OGGTrack(fSound);
            } else if (trackName.endsWith(".flac")) {
                result = new FlacTrack(fSound);
            } else if (trackName.endsWith(".wav") || trackName.endsWith(".au") || trackName.endsWith(".snd") || trackName.endsWith(".aiff") || trackName.endsWith(".aifc")) {
                result = new PCMTrack(fSound);
            } else if (trackName.endsWith(".m4a") || trackName.endsWith(".aac")) {
                result = new M4ATrack(fSound);
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException | InvalidAudioFrameException exception) {
            // empty catch block
        }
        return result;
    }

    public static Track getTrack(String trackPath) {
        return Track.getTrack(new File(trackPath));
    }

    public static Track getTrack(InputStream inputStream) {
        Track result;
        try {
            result = new MP3Track(inputStream);
        }
        catch (Exception e) {
            result = null;
        }
        if (result == null) {
            try {
                result = new OGGTrack(inputStream);
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                result = new PCMTrack(inputStream);
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                result = new FlacTrack(inputStream);
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                result = new M4ATrack(inputStream);
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    public static boolean isValidTrack(String trackPath) {
        return Track.isValidTrack(new File(trackPath));
    }

    public static boolean isValidTrack(File track) {
        boolean isSupported = AudioUtil.isSupported(track);
        return isSupported;
    }

    protected Track(File dataSource) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.dataSource = dataSource;
        this.source = dataSource;
        this.state = (byte)3;
        this.secsSeeked = 0.0;
        this.volume = Player.DEFAULT_VOLUME;
        this.initAll();
        try {
            if (this.isValidTrack()) {
                this.tagInfo = new AudioTag(dataSource);
            }
        }
        catch (CannotReadException | InvalidAudioFrameException | ReadOnlyFileException | TagException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
        this.setPriority(10);
    }

    protected Track(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.source = inputStream;
        this.state = (byte)3;
        this.secsSeeked = 0.0;
        this.volume = Player.DEFAULT_VOLUME;
        this.initAll();
        this.setPriority(10);
    }

    protected Track(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(new File(trackPath));
    }

    protected abstract void loadAudioStream() throws IOException, UnsupportedAudioFileException;

    protected void resetLine() throws LineUnavailableException {
        this.trackLine.stop();
        this.trackLine.open();
    }

    public void resetStream() throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        this.closeAllStreams();
        this.initAll();
    }

    protected void initLine() throws LineUnavailableException {
        if (this.trackStream != null) {
            if (this.trackLine != null) {
                this.trackLine.stop();
                this.trackLine.close();
            }
            try {
                this.trackLine = new Speaker(this.trackStream.getFormat());
                this.trackLine.open();
                this.setGain(this.volume);
            }
            catch (IllegalArgumentException e1) {
                System.err.println("Error: " + e1.getMessage());
            }
        } else {
            System.out.println("TrackStream & TrackLine null");
        }
    }

    protected void initAll() throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.loadAudioStream();
        this.initLine();
    }

    protected void closeLine() {
        if (this.trackLine != null) {
            this.trackLine.stop();
            this.trackLine.close();
            this.trackLine = null;
        }
    }

    public void closeAllStreams() {
        this.closeLine();
        this.secsSeeked = 0.0;
        try {
            this.trackStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected double getSecondsPosition() {
        if (this.trackLine == null) {
            return 0.0;
        }
        return (double)this.trackLine.getDriver().getMicrosecondPosition() / 1000000.0;
    }

    public boolean isValidTrack() {
        return this.trackStream != null && this.trackLine != null;
    }

    public boolean hasPlayerAssociated() {
        return PlayerHandler.hasInstance();
    }

    public double getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public AudioInputStream getDecodedStream() {
        return this.trackStream;
    }

    public synchronized boolean hasValidTrackLine() {
        return this.trackLine != null;
    }

    public synchronized Speaker getTrackLine() {
        return this.trackLine;
    }

    public byte getTrackState() {
        return this.state;
    }

    public String getStateToString() {
        switch (this.state) {
            case 1: {
                return "Playing";
            }
            case 2: {
                return "Paused";
            }
            case 3: {
                return "Stopped";
            }
            case 5: {
                return "Finished";
            }
            case 6: {
                return "Killed";
            }
        }
        return "Unknown";
    }

    public File getDataSource() {
        return this.dataSource;
    }

    public AudioTag getTagInfo() {
        return this.tagInfo;
    }

    @Override
    public synchronized double getProgress() {
        return this.getSecondsPosition() + this.secsSeeked;
    }

    public synchronized String getFormattedProgress() {
        return TimeFormatter.format((long)this.getProgress());
    }

    public AudioFileFormat getFileFormat() throws IOException, UnsupportedAudioFileException {
        return this.audioReader == null ? null : this.audioReader.getAudioFileFormat(this.dataSource);
    }

    public AudioFormat getAudioFormat() {
        return this.trackStream.getFormat();
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.state == 1;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.state == 2;
    }

    @Override
    public synchronized boolean isStopped() {
        return this.state == 3;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.state == 5;
    }

    public synchronized boolean isKilled() {
        return this.state == 6;
    }

    @Override
    public boolean isMute() {
        return this.isMute;
    }

    @Override
    public void play() {
        if (this.isAlive()) {
            this.state = 1;
        }
    }

    @Override
    public void pause() {
        if (this.isPlaying()) {
            this.suspend();
            this.state = (byte)2;
        }
    }

    @Override
    public void resumeTrack() {
        if (this.isAlive() && (this.isPaused() || this.isStopped())) {
            this.resume();
            this.play();
        }
    }

    @Override
    public synchronized void stopTrack() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        if (this.isAlive() && (this.isPlaying() || this.isPaused())) {
            if (this.isPlaying()) {
                this.suspend();
            }
            this.resetStream();
            this.state = (byte)3;
            this.secsSeeked = 0.0;
        }
    }

    @Override
    public void finish() {
        this.state = (byte)5;
        this.closeAllStreams();
    }

    void kill() {
        this.state = (byte)6;
        this.closeAllStreams();
    }

    @Override
    public void seek(double seconds) throws IOException {
        if (seconds == 0.0) {
            return;
        }
        this.secsSeeked += seconds;
        AudioFormat audioFormat = this.getAudioFormat();
        float frameRate = audioFormat.getFrameRate();
        int frameSize = audioFormat.getFrameSize();
        double framesToSeek = (double)frameRate * seconds;
        long seek = Math.round(framesToSeek * (double)frameSize);
        this.trackStream.skip(seek);
    }

    @Override
    public void gotoSecond(double second) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        double progress = this.getProgress();
        if (second >= progress) {
            int duration = (int)this.getDuration();
            if (second > (double)duration) {
                second = duration;
            }
            int gt = (int)Math.round(second - this.getProgress());
            this.seek(gt);
        } else if (second < progress) {
            if (second < 0.0) {
                second = 0.0;
            }
            this.stopTrack();
            this.seek(second);
            this.resumeTrack();
        }
    }

    @Override
    public float getGain() {
        return this.isMute ? 0.0f : this.volume;
    }

    @Override
    public void setGain(float volume) {
        if (this.isValidTrack()) {
            float f = volume > 100.0f ? 100.0f : (this.volume = volume < 0.0f ? 0.0f : volume);
            if (this.trackLine != null) {
                this.trackLine.setGain(AudioUtil.convertVolRangeToLineRange(volume));
            }
            this.isMute = this.volume == 0.0f;
        }
    }

    @Override
    public void mute() {
        if (this.isValidTrack() && !this.isMute) {
            this.isMute = true;
            if (this.trackLine != null) {
                this.trackLine.setGain(AudioUtil.convertVolRangeToLineRange(0.0f));
            }
        }
    }

    @Override
    public void unmute() {
        if (this.isValidTrack() && this.isMute) {
            this.isMute = false;
            this.setGain(this.volume);
        }
    }

    @Override
    public boolean hasCover() {
        return this.tagInfo.getCover() != null;
    }

    @Override
    public String getProperty(String key) {
        return this.tagInfo == null ? null : this.tagInfo.getTag(key);
    }

    @Override
    public String getProperty(FieldKey key) {
        if (this.tagInfo == null) {
            return null;
        }
        return this.tagInfo.getTag(key);
    }

    @Override
    public String getTitle() {
        String titleProper = this.getProperty(FieldKey.TITLE);
        return (titleProper == null || titleProper.isEmpty()) && this.dataSource != null ? this.dataSource.getName() : titleProper;
    }

    @Override
    public String getAlbum() {
        return this.getProperty(FieldKey.ALBUM);
    }

    @Override
    public String getArtist() {
        return this.getProperty(FieldKey.ARTIST);
    }

    @Override
    public String getDate() {
        return this.getProperty(FieldKey.YEAR);
    }

    @Override
    public byte[] getCoverData() {
        return this.tagInfo.getCoverData();
    }

    @Override
    public long getDuration() {
        return this.tagInfo.getDuration();
    }

    @Override
    public String getEncoder() {
        return this.getProperty(FieldKey.ENCODER);
    }

    public String getFormat() {
        return this.trackStream.getFormat().toString();
    }

    public String getSongInfo() {
        int i;
        StringBuilder sbInfo = new StringBuilder();
        String title = this.getTitle();
        String album = this.getAlbum();
        String artist = this.getArtist();
        String date = this.getDate();
        String duration = this.getDurationAsString();
        String hasCover = this.hasCover() ? "Si" : "No";
        String encoder = this.getEncoder();
        StringBuilder sbTabs = new StringBuilder();
        String currentLine = "Song: " + title;
        int biggerLenght = currentLine.length();
        sbInfo.append(currentLine).append('\n');
        if (album != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Album: " + album;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (artist != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Artist: " + artist;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (date != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Date: " + date;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (duration != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Duration: " + duration;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (hasCover != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Has Cover: " + hasCover;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        if (encoder != null) {
            sbTabs.append("    ");
            currentLine = sbTabs.toString() + "Encoder: " + encoder;
            if (biggerLenght < currentLine.length()) {
                biggerLenght = currentLine.length();
            }
            sbInfo.append(currentLine).append('\n');
        }
        sbTabs.delete(0, sbTabs.length());
        for (i = 0; i < biggerLenght; ++i) {
            sbTabs.append('-');
        }
        sbTabs.append('\n').append(sbInfo.toString());
        for (i = 0; i < biggerLenght; ++i) {
            sbTabs.append('-');
        }
        sbTabs.append('\n');
        return sbTabs.toString();
    }

    public void getLineInfo() {
        SourceDataLine driver = this.trackLine.getDriver();
        System.out.println("Soporte de controles en line");
        System.out.println("---------------");
        System.out.println("Pan: " + driver.isControlSupported(FloatControl.Type.PAN));
        System.out.println("AuxReturn: " + driver.isControlSupported(FloatControl.Type.AUX_RETURN));
        System.out.println("AuxSend: " + driver.isControlSupported(FloatControl.Type.AUX_SEND));
        System.out.println("Balance: " + driver.isControlSupported(FloatControl.Type.BALANCE));
        System.out.println("ReverbReturn: " + driver.isControlSupported(FloatControl.Type.REVERB_RETURN));
        System.out.println("ReberbSend: " + driver.isControlSupported(FloatControl.Type.REVERB_SEND));
        System.out.println("Volume: " + driver.isControlSupported(FloatControl.Type.VOLUME));
        System.out.println("SampleRate: " + driver.isControlSupported(FloatControl.Type.SAMPLE_RATE));
        System.out.println("MasterGain: " + driver.isControlSupported(FloatControl.Type.MASTER_GAIN));
    }

    @Override
    public void run() {
        boolean isPlayerLinked = PlayerHandler.hasInstance();
        byte[] audioBuffer = new byte[4096];
        this.play();
        TPlayingTrack threadPlaying = new TPlayingTrack(this);
        threadPlaying.start();
        while (!this.isFinished() && !this.isKilled() && this.isValidTrack()) {
            try {
                while (this.isPlaying()) {
                    try {
                        if (this.isPaused()) break;
                        int read = this.trackStream.read(audioBuffer);
                        if (read == -1) {
                            this.finish();
                            break;
                        }
                        this.trackLine.playAudio(audioBuffer);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.finish();
                    }
                }
                Thread.sleep(50L);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                this.finish();
                Logger.getLogger(this, (Object)e.getMessage()).error();
                break;
            }
        }
        if (this.isFinished() && isPlayerLinked && PlayerHandler.hasInstance()) {
            PlayerHandler.getPlayer().playNext();
        }
    }
}

