/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Scanner;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Player;
import org.muplayer.audio.Track;
import org.muplayer.audio.interfaces.PlayerListener;
import org.muplayer.main.ConsoleInterpreter;
import org.muplayer.system.SysInfo;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public class ConsolePlayer
extends Thread {
    protected volatile Player player;
    protected volatile ConsoleInterpreter interpreter;
    protected volatile File playerFolder;
    protected volatile Scanner scanner;
    protected static final String LINEHEADER = "[MuPlayer]> ";

    public ConsolePlayer(File rootFolder) throws FileNotFoundException {
        this.player = new Player(rootFolder);
        this.interpreter = new ConsoleInterpreter(this.player);
        this.playerFolder = rootFolder;
        this.scanner = new Scanner(System.in);
        this.setName("ConsolePlayer");
    }

    public ConsolePlayer(String folder) throws FileNotFoundException {
        this(new File(folder));
    }

    protected void configListener() {
        this.player.addPlayerListener(new PlayerListener(){

            @Override
            public void onSongChange(Track newTrack) {
                ConsolePlayer.this.interpreter.showSongInfo(newTrack);
            }

            @Override
            public void onPlayed(Track track) {
            }

            @Override
            public void onPlaying(Track track) {
            }

            @Override
            public void onResumed(Track track) {
            }

            @Override
            public void onPaused(Track track) {
            }

            @Override
            public void onStarted() {
            }

            @Override
            public void onStopped(Track track) {
            }

            @Override
            public void onSeeked(Track track) {
            }

            @Override
            public void onShutdown() {
            }
        });
    }

    protected void printHeader() {
        FileOutputStream stdout = SystemUtil.getStdout();
        try {
            stdout.write(Logger.getLogger(this, (Object)LINEHEADER).getColoredMsg("\u001b[32m").getBytes());
            stdout.flush();
        }
        catch (IOException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void execCommand(String strCmd) {
        try {
            this.interpreter.preInterprate(strCmd);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (SysInfo.VERSION == null) {
            Logger.getLogger(this, (Object)"MuPlayer started...").rawInfo();
        } else {
            Logger.getLogger(this, (Object)("MuPlayer v" + SysInfo.VERSION + " started...")).rawInfo();
        }
        this.interpreter.setOn(true);
        while (this.interpreter.isOn()) {
            this.printHeader();
            this.execCommand(this.scanner.nextLine().trim());
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                new ConsolePlayer("/home/martin/Escritorio/M\u00fasica").start();
            } else {
                new ConsolePlayer(args[0]).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

