/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.StreamCorruptedException;
import org.jetbrains.annotations.Nullable;
import org.xiph.speex.Bits;
import org.xiph.speex.Decoder;
import org.xiph.speex.Filters;
import org.xiph.speex.Lsp;
import org.xiph.speex.NbDecoder;
import org.xiph.speex.SbCodec;
import org.xiph.speex.Stereo;

public class SbDecoder
extends SbCodec
implements Decoder {
    protected Decoder lowdec;
    protected final Stereo stereo = new Stereo();
    protected boolean enhanced = true;
    private float[] innov2;

    public void wbinit() {
        this.lowdec = new NbDecoder();
        ((NbDecoder)this.lowdec).nbinit();
        this.lowdec.setPerceptualEnhancement(this.enhanced);
        super.wbinit();
        this.init(160, 40, 8, 640, 0.7f);
    }

    public void uwbinit() {
        this.lowdec = new SbDecoder();
        ((SbDecoder)this.lowdec).wbinit();
        this.lowdec.setPerceptualEnhancement(this.enhanced);
        super.uwbinit();
        this.init(320, 80, 8, 1280, 0.5f);
    }

    public void init(int frameSize, int subframeSize, int lpcSize, int bufSize, float foldingGain) {
        super.init(frameSize, subframeSize, lpcSize, bufSize, foldingGain);
        this.excIdx = 0;
        this.innov2 = new float[subframeSize];
    }

    public int decode(@Nullable Bits bits, float[] out) throws StreamCorruptedException {
        int i;
        int ret = this.lowdec.decode(bits, this.x0d);
        if (ret != 0) {
            return ret;
        }
        boolean dtx = this.lowdec.getDtx();
        if (bits == null) {
            this.decodeLost(out, dtx);
            return 0;
        }
        int wideband = bits.peek();
        if (wideband != 0) {
            wideband = bits.unpack(1);
            this.submodeID = bits.unpack(3);
        } else {
            this.submodeID = 0;
        }
        for (i = 0; i < this.frameSize; ++i) {
            this.excBuf[i] = 0.0f;
        }
        if (this.submodes[this.submodeID] == null) {
            if (dtx) {
                this.decodeLost(out, true);
                return 0;
            }
            for (i = 0; i < this.frameSize; ++i) {
                this.excBuf[i] = 0.0f;
            }
            this.first = 1;
            Filters.iir_mem2(this.excBuf, this.excIdx, this.interp_qlpc, this.high, 0, this.frameSize, this.lpcSize, this.mem_sp);
            this.filters.fir_mem_up(this.x0d, h0, this.y0, this.fullFrameSize, 64, this.g0_mem);
            this.filters.fir_mem_up(this.high, h1, this.y1, this.fullFrameSize, 64, this.g1_mem);
            for (i = 0; i < this.fullFrameSize; ++i) {
                out[i] = 2.0f * (this.y0[i] - this.y1[i]);
            }
            return 0;
        }
        float[] low_pi_gain = this.lowdec.getPiGain();
        float[] low_exc = this.lowdec.getExc();
        float[] low_innov = this.lowdec.getInnov();
        this.submodes[this.submodeID].lsqQuant.unquant(this.qlsp, this.lpcSize, bits);
        if (this.first != 0) {
            for (i = 0; i < this.lpcSize; ++i) {
                this.old_qlsp[i] = this.qlsp[i];
            }
        }
        for (int sub = 0; sub < this.nbSubframes; ++sub) {
            float el = 0.0f;
            float rl = 0.0f;
            float rh = 0.0f;
            int subIdx = this.subframeSize * sub;
            float tmp = (1.0f + (float)sub) / (float)this.nbSubframes;
            for (i = 0; i < this.lpcSize; ++i) {
                this.interp_qlsp[i] = (1.0f - tmp) * this.old_qlsp[i] + tmp * this.qlsp[i];
            }
            Lsp.enforce_margin(this.interp_qlsp, this.lpcSize, 0.05f);
            for (i = 0; i < this.lpcSize; ++i) {
                this.interp_qlsp[i] = (float)Math.cos(this.interp_qlsp[i]);
            }
            this.m_lsp.lsp2lpc(this.interp_qlsp, this.interp_qlpc, this.lpcSize);
            if (this.enhanced) {
                float k1 = this.submodes[this.submodeID].lpc_enh_k1;
                float k2 = this.submodes[this.submodeID].lpc_enh_k2;
                float k3 = k1 - k2;
                Filters.bw_lpc(k1, this.interp_qlpc, this.awk1, this.lpcSize);
                Filters.bw_lpc(k2, this.interp_qlpc, this.awk2, this.lpcSize);
                Filters.bw_lpc(k3, this.interp_qlpc, this.awk3, this.lpcSize);
            }
            tmp = 1.0f;
            this.pi_gain[sub] = 0.0f;
            for (i = 0; i <= this.lpcSize; ++i) {
                rh += tmp * this.interp_qlpc[i];
                tmp = -tmp;
                int n = sub;
                this.pi_gain[n] = this.pi_gain[n] + this.interp_qlpc[i];
            }
            rl = low_pi_gain[sub];
            rl = 1.0f / (Math.abs(rl) + 0.01f);
            rh = 1.0f / (Math.abs(rh) + 0.01f);
            float filter_ratio = Math.abs(0.01f + rh) / (0.01f + Math.abs(rl));
            for (i = subIdx; i < subIdx + this.subframeSize; ++i) {
                this.excBuf[i] = 0.0f;
            }
            if (this.submodes[this.submodeID].innovation == null) {
                int quant = bits.unpack(5);
                float g = (float)Math.exp(((double)quant - 10.0) / 8.0);
                g /= filter_ratio;
                for (i = subIdx; i < subIdx + this.subframeSize; ++i) {
                    this.excBuf[i] = this.foldingGain * g * low_innov[i];
                }
            } else {
                int qgc = bits.unpack(4);
                for (i = subIdx; i < subIdx + this.subframeSize; ++i) {
                    el += low_exc[i] * low_exc[i];
                }
                float gc = (float)Math.exp(0.27027026f * (float)qgc - 2.0f);
                float scale = gc * (float)Math.sqrt(1.0f + el) / filter_ratio;
                this.submodes[this.submodeID].innovation.unquant(this.excBuf, subIdx, this.subframeSize, bits);
                i = subIdx;
                while (i < subIdx + this.subframeSize) {
                    int n = i++;
                    this.excBuf[n] = this.excBuf[n] * scale;
                }
                if (this.submodes[this.submodeID].double_codebook != 0) {
                    for (i = 0; i < this.subframeSize; ++i) {
                        this.innov2[i] = 0.0f;
                    }
                    this.submodes[this.submodeID].innovation.unquant(this.innov2, 0, this.subframeSize, bits);
                    i = 0;
                    while (i < this.subframeSize) {
                        int n = i++;
                        this.innov2[n] = this.innov2[n] * (scale * 0.4f);
                    }
                    for (i = 0; i < this.subframeSize; ++i) {
                        int n = subIdx + i;
                        this.excBuf[n] = this.excBuf[n] + this.innov2[i];
                    }
                }
            }
            for (i = subIdx; i < subIdx + this.subframeSize; ++i) {
                this.high[i] = this.excBuf[i];
            }
            if (this.enhanced) {
                Filters.filter_mem2(this.high, subIdx, this.awk2, this.awk1, this.subframeSize, this.lpcSize, this.mem_sp, this.lpcSize);
                Filters.filter_mem2(this.high, subIdx, this.awk3, this.interp_qlpc, this.subframeSize, this.lpcSize, this.mem_sp, 0);
                continue;
            }
            for (i = 0; i < this.lpcSize; ++i) {
                this.mem_sp[this.lpcSize + i] = 0.0f;
            }
            Filters.iir_mem2(this.high, subIdx, this.interp_qlpc, this.high, subIdx, this.subframeSize, this.lpcSize, this.mem_sp);
        }
        this.filters.fir_mem_up(this.x0d, h0, this.y0, this.fullFrameSize, 64, this.g0_mem);
        this.filters.fir_mem_up(this.high, h1, this.y1, this.fullFrameSize, 64, this.g1_mem);
        for (i = 0; i < this.fullFrameSize; ++i) {
            out[i] = 2.0f * (this.y0[i] - this.y1[i]);
        }
        for (i = 0; i < this.lpcSize; ++i) {
            this.old_qlsp[i] = this.qlsp[i];
        }
        this.first = 0;
        return 0;
    }

    public int decodeLost(float[] out, boolean dtx) {
        int i;
        int saved_modeid = 0;
        if (dtx) {
            saved_modeid = this.submodeID;
            this.submodeID = 1;
        } else {
            Filters.bw_lpc(0.99f, this.interp_qlpc, this.interp_qlpc, this.lpcSize);
        }
        this.first = 1;
        this.awk1 = new float[this.lpcSize + 1];
        this.awk2 = new float[this.lpcSize + 1];
        this.awk3 = new float[this.lpcSize + 1];
        if (this.enhanced) {
            float k2;
            float k1;
            if (this.submodes[this.submodeID] != null) {
                k1 = this.submodes[this.submodeID].lpc_enh_k1;
                k2 = this.submodes[this.submodeID].lpc_enh_k2;
            } else {
                k2 = 0.7f;
                k1 = 0.7f;
            }
            float k3 = k1 - k2;
            Filters.bw_lpc(k1, this.interp_qlpc, this.awk1, this.lpcSize);
            Filters.bw_lpc(k2, this.interp_qlpc, this.awk2, this.lpcSize);
            Filters.bw_lpc(k3, this.interp_qlpc, this.awk3, this.lpcSize);
        }
        if (!dtx) {
            for (i = 0; i < this.frameSize; ++i) {
                int n = this.excIdx + i;
                this.excBuf[n] = (float)((double)this.excBuf[n] * 0.9);
            }
        }
        for (i = 0; i < this.frameSize; ++i) {
            this.high[i] = this.excBuf[this.excIdx + i];
        }
        if (this.enhanced) {
            Filters.filter_mem2(this.high, 0, this.awk2, this.awk1, this.high, 0, this.frameSize, this.lpcSize, this.mem_sp, this.lpcSize);
            Filters.filter_mem2(this.high, 0, this.awk3, this.interp_qlpc, this.high, 0, this.frameSize, this.lpcSize, this.mem_sp, 0);
        } else {
            for (i = 0; i < this.lpcSize; ++i) {
                this.mem_sp[this.lpcSize + i] = 0.0f;
            }
            Filters.iir_mem2(this.high, 0, this.interp_qlpc, this.high, 0, this.frameSize, this.lpcSize, this.mem_sp);
        }
        this.filters.fir_mem_up(this.x0d, h0, this.y0, this.fullFrameSize, 64, this.g0_mem);
        this.filters.fir_mem_up(this.high, h1, this.y1, this.fullFrameSize, 64, this.g1_mem);
        for (i = 0; i < this.fullFrameSize; ++i) {
            out[i] = 2.0f * (this.y0[i] - this.y1[i]);
        }
        if (dtx) {
            this.submodeID = saved_modeid;
        }
        return 0;
    }

    public void decodeStereo(float[] data, int frameSize) {
        this.stereo.decode(data, frameSize);
    }

    public void setPerceptualEnhancement(boolean enhanced) {
        this.enhanced = enhanced;
    }

    public boolean getPerceptualEnhancement() {
        return this.enhanced;
    }
}

