/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class AppInfo {
    private final File fileProps = new File("config.properties");
    private Properties props = new Properties();
    private static AppInfo singleton;

    public static AppInfo getInstance() {
        if (singleton == null) {
            singleton = new AppInfo();
        }
        return singleton;
    }

    private AppInfo() {
        if (!this.fileProps.exists()) {
            try {
                this.fileProps.createNewFile();
                this.saveData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadData() {
        try {
            this.props = new Properties();
            this.props.load(new InputStreamReader((InputStream)new FileInputStream(this.fileProps), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveData() {
        try {
            this.props.store(new FileOutputStream(this.fileProps), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String get(String key) {
        this.loadData();
        return this.props.getProperty(key);
    }

    public void set(String key, String value) {
        this.props.setProperty(key, value);
        this.saveData();
    }
}

