/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.UnsupportedEncodingException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.id3.ID3v1FieldKey;

public class ID3v1TagField
implements TagTextField {
    private boolean common;
    private String content;
    private String id;

    public ID3v1TagField(byte[] raw) throws UnsupportedEncodingException {
        String field = new String(raw, "ISO-8859-1");
        int i = field.indexOf("=");
        if (i == -1) {
            this.id = "ERRONEOUS";
            this.content = field;
        } else {
            this.id = field.substring(0, i).toUpperCase();
            this.content = field.length() > i ? field.substring(i + 1) : "";
        }
        this.checkCommon();
    }

    public ID3v1TagField(String fieldId, String fieldContent) {
        this.id = fieldId.toUpperCase();
        this.content = fieldContent;
        this.checkCommon();
    }

    private void checkCommon() {
        this.common = this.id.equals(ID3v1FieldKey.TITLE.name()) || this.id.equals(ID3v1FieldKey.ALBUM.name()) || this.id.equals(ID3v1FieldKey.ARTIST.name()) || this.id.equals(ID3v1FieldKey.GENRE.name()) || this.id.equals(ID3v1FieldKey.YEAR.name()) || this.id.equals(ID3v1FieldKey.COMMENT.name()) || this.id.equals(ID3v1FieldKey.TRACK.name());
    }

    protected void copy(byte[] src, byte[] dst, int dstOffset) {
        System.arraycopy(src, 0, dst, dstOffset, src.length);
    }

    public void copyContent(TagField field) {
        if (field instanceof TagTextField) {
            this.content = ((TagTextField)field).getContent();
        }
    }

    public String getContent() {
        return this.content;
    }

    public String getEncoding() {
        return "ISO-8859-1";
    }

    public String getId() {
        return this.id;
    }

    public byte[] getRawContent() throws UnsupportedEncodingException {
        byte[] size = new byte[4];
        byte[] idBytes = this.id.getBytes("ISO-8859-1");
        byte[] contentBytes = Utils.getDefaultBytes(this.content, "ISO-8859-1");
        byte[] b = new byte[4 + idBytes.length + 1 + contentBytes.length];
        int length = idBytes.length + 1 + contentBytes.length;
        size[3] = (byte)((length & 0xFF000000) >> 24);
        size[2] = (byte)((length & 0xFF0000) >> 16);
        size[1] = (byte)((length & 0xFF00) >> 8);
        size[0] = (byte)(length & 0xFF);
        int offset = 0;
        this.copy(size, b, offset);
        this.copy(idBytes, b, offset += 4);
        b[offset += idBytes.length] = 61;
        this.copy(contentBytes, b, ++offset);
        return b;
    }

    public boolean isBinary() {
        return false;
    }

    public void isBinary(boolean b) {
    }

    public boolean isCommon() {
        return this.common;
    }

    public boolean isEmpty() {
        return this.content.equals("");
    }

    public void setContent(String s) {
        this.content = s;
    }

    public void setEncoding(String s) {
    }

    public String toString() {
        return this.getContent();
    }
}

