/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.xiph.speex.AudioFileWriter;
import org.xiph.speex.NbEncoder;
import org.xiph.speex.OggCrc;
import org.xiph.speex.PcmWaveWriter;
import org.xiph.speex.RawWriter;
import org.xiph.speex.SbEncoder;
import org.xiph.speex.SpeexDecoder;

public class JSpeexDec {
    public static final String VERSION = "Java Speex Command Line Decoder v0.9.7 ($Revision$)";
    public static final String COPYRIGHT = "Copyright (C) 2002-2004 Wimba S.A.";
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    protected int printlevel = 1;
    public static final int FILE_FORMAT_RAW = 0;
    public static final int FILE_FORMAT_OGG = 1;
    public static final int FILE_FORMAT_WAVE = 2;
    protected int srcFormat = 1;
    protected int destFormat = 2;
    @NotNull
    protected static final Random random = new Random();
    protected SpeexDecoder speexDecoder;
    protected boolean enhanced = true;
    private int mode = 0;
    private int quality = 8;
    private int nframes = 1;
    private int sampleRate = -1;
    private float vbr_quality = -1.0f;
    private boolean vbr = false;
    private int channels = 1;
    private int loss = 0;
    protected String srcFile;
    protected String destFile;

    public static void main(@NotNull String[] args) throws IOException {
        JSpeexDec decoder = new JSpeexDec();
        if (decoder.parseArgs(args)) {
            decoder.decode();
        }
    }

    public boolean parseArgs(@NotNull String[] args) {
        if (args.length < 2) {
            if (args.length == 1 && (args[0].equals("-v") || args[0].equals("--version"))) {
                JSpeexDec.version();
                return false;
            }
            JSpeexDec.usage();
            return false;
        }
        this.srcFile = args[args.length - 2];
        this.destFile = args[args.length - 1];
        this.srcFormat = this.srcFile.toLowerCase().endsWith(".spx") ? 1 : (this.srcFile.toLowerCase().endsWith(".wav") ? 2 : 0);
        this.destFormat = this.destFile.toLowerCase().endsWith(".wav") ? 2 : 0;
        for (int i = 0; i < args.length - 2; ++i) {
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("--help")) {
                JSpeexDec.usage();
                return false;
            }
            if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("--version")) {
                JSpeexDec.version();
                return false;
            }
            if (args[i].equalsIgnoreCase("--verbose")) {
                this.printlevel = 0;
                continue;
            }
            if (args[i].equalsIgnoreCase("--quiet")) {
                this.printlevel = 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--enh")) {
                this.enhanced = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--no-enh")) {
                this.enhanced = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("--packet-loss")) {
                try {
                    this.loss = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JSpeexDec.usage();
                    return false;
                }
            }
            if (args[i].equalsIgnoreCase("-n") || args[i].equalsIgnoreCase("-nb") || args[i].equalsIgnoreCase("--narrowband")) {
                this.mode = 0;
                continue;
            }
            if (args[i].equalsIgnoreCase("-w") || args[i].equalsIgnoreCase("-wb") || args[i].equalsIgnoreCase("--wideband")) {
                this.mode = 1;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u") || args[i].equalsIgnoreCase("-uwb") || args[i].equalsIgnoreCase("--ultra-wideband")) {
                this.mode = 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-q") || args[i].equalsIgnoreCase("--quality")) {
                try {
                    this.vbr_quality = Float.parseFloat(args[++i]);
                    this.quality = (int)this.vbr_quality;
                    continue;
                }
                catch (NumberFormatException e) {
                    JSpeexDec.usage();
                    return false;
                }
            }
            if (args[i].equalsIgnoreCase("--nframes")) {
                try {
                    this.nframes = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JSpeexDec.usage();
                    return false;
                }
            }
            if (args[i].equalsIgnoreCase("--vbr")) {
                this.vbr = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--stereo")) {
                this.channels = 2;
                continue;
            }
            JSpeexDec.usage();
            return false;
        }
        if (this.sampleRate < 0) {
            switch (this.mode) {
                case 0: {
                    this.sampleRate = 8000;
                    break;
                }
                case 1: {
                    this.sampleRate = 16000;
                    break;
                }
                case 2: {
                    this.sampleRate = 32000;
                    break;
                }
                default: {
                    this.sampleRate = 8000;
                }
            }
        }
        return true;
    }

    public static void usage() {
        JSpeexDec.version();
        System.out.println("Usage: JSpeexDec [options] input_file output_file");
        System.out.println("Where:");
        System.out.println("  input_file can be:");
        System.out.println("    filename.spx  an Ogg Speex file");
        System.out.println("    filename.wav  a Wave Speex file (beta!!!)");
        System.out.println("    filename.*    a raw Speex file");
        System.out.println("  output_file can be:");
        System.out.println("    filename.wav  a PCM wav file");
        System.out.println("    filename.*    a raw PCM file (any extension other than .wav)");
        System.out.println("Options: -h, --help     This help");
        System.out.println("         -v, --version    Version information");
        System.out.println("         --verbose        Print detailed information");
        System.out.println("         --quiet          Print minimal information");
        System.out.println("         --enh            Enable perceptual enhancement (default)");
        System.out.println("         --no-enh         Disable perceptual enhancement");
        System.out.println("         --packet-loss n  Simulate n % random packet loss");
        System.out.println("         if the input file is raw Speex (not Ogg Speex)");
        System.out.println("         -n, -nb          Narrowband (8kHz)");
        System.out.println("         -w, -wb          Wideband (16kHz)");
        System.out.println("         -u, -uwb         Ultra-Wideband (32kHz)");
        System.out.println("         --quality n      Encoding quality (0-10) default 8");
        System.out.println("         --nframes n      Number of frames per Ogg packet, default 1");
        System.out.println("         --vbr            Enable varible bit-rate (VBR)");
        System.out.println("         --stereo         Consider input as stereo");
        System.out.println("More information is available from: http://jspeex.sourceforge.net/");
        System.out.println("This code is a Java port of the Speex codec: http://www.speex.org/");
    }

    public static void version() {
        System.out.println(VERSION);
        System.out.println("using Java Speex Decoder v0.9.7 ($Revision$)");
        System.out.println(COPYRIGHT);
    }

    public void decode() throws IOException {
        this.decode(new File(this.srcFile), new File(this.destFile));
    }

    public void decode(@NotNull File srcPath, File destPath) throws IOException {
        byte[] header = new byte[2048];
        byte[] payload = new byte[65536];
        byte[] decdat = new byte[176400];
        int WAV_HEADERSIZE = 8;
        int WAVE_FORMAT_SPEEX = -24311;
        String RIFF = "RIFF";
        String WAVE = "WAVE";
        String FORMAT = "fmt ";
        String DATA = "data";
        int OGG_HEADERSIZE = 27;
        int OGG_SEGOFFSET = 26;
        String OGGID = "OggS";
        int segments = 0;
        int curseg = 0;
        int bodybytes = 0;
        int decsize = 0;
        int packetNo = 0;
        if (this.printlevel <= 1) {
            JSpeexDec.version();
        }
        if (this.printlevel <= 0) {
            System.out.println("");
        }
        if (this.printlevel <= 0) {
            System.out.println("Input File: " + srcPath);
        }
        this.speexDecoder = new SpeexDecoder();
        DataInputStream dis = new DataInputStream(new FileInputStream(srcPath));
        AudioFileWriter writer = null;
        try {
            while (true) {
                int i;
                if (this.srcFormat == 1) {
                    dis.readFully(header, 0, 27);
                    int origchksum = JSpeexDec.readInt(header, 22);
                    header[22] = 0;
                    header[23] = 0;
                    header[24] = 0;
                    header[25] = 0;
                    int chksum = OggCrc.checksum(0, header, 0, 27);
                    if (!"OggS".equals(new String(header, 0, 4))) {
                        System.err.println("missing ogg id!");
                        return;
                    }
                    segments = header[26] & 0xFF;
                    dis.readFully(header, 27, segments);
                    chksum = OggCrc.checksum(chksum, header, 27, segments);
                    for (curseg = 0; curseg < segments; ++curseg) {
                        int i2;
                        bodybytes = header[27 + curseg] & 0xFF;
                        if (bodybytes == 255) {
                            System.err.println("sorry, don't handle 255 sizes!");
                            return;
                        }
                        dis.readFully(payload, 0, bodybytes);
                        chksum = OggCrc.checksum(chksum, payload, 0, bodybytes);
                        if (packetNo == 0) {
                            if (this.readSpeexHeader(payload, 0, bodybytes)) {
                                if (this.printlevel <= 0) {
                                    System.out.println("File Format: Ogg Speex");
                                    System.out.println("Sample Rate: " + this.sampleRate);
                                    System.out.println("Channels: " + this.channels);
                                    System.out.println("Encoder mode: " + (this.mode == 0 ? "Narrowband" : (this.mode == 1 ? "Wideband" : "UltraWideband")));
                                    System.out.println("Frames per packet: " + this.nframes);
                                }
                                if (this.destFormat == 2) {
                                    writer = new PcmWaveWriter(this.speexDecoder.getSampleRate(), this.speexDecoder.getChannels());
                                    if (this.printlevel <= 0) {
                                        System.out.println("");
                                        System.out.println("Output File: " + destPath);
                                        System.out.println("File Format: PCM Wave");
                                        System.out.println("Perceptual Enhancement: " + this.enhanced);
                                    }
                                } else {
                                    writer = new RawWriter();
                                    if (this.printlevel <= 0) {
                                        System.out.println("");
                                        System.out.println("Output File: " + destPath);
                                        System.out.println("File Format: Raw Audio");
                                        System.out.println("Perceptual Enhancement: " + this.enhanced);
                                    }
                                }
                                writer.open(destPath);
                                writer.writeHeader(null);
                                ++packetNo;
                                continue;
                            }
                            packetNo = 0;
                            continue;
                        }
                        if (packetNo == 1) {
                            ++packetNo;
                            continue;
                        }
                        if (this.loss > 0 && random.nextInt(100) < this.loss) {
                            this.speexDecoder.processData(null, 0, bodybytes);
                            for (i2 = 1; i2 < this.nframes; ++i2) {
                                this.speexDecoder.processData(true);
                            }
                        } else {
                            this.speexDecoder.processData(payload, 0, bodybytes);
                            for (i2 = 1; i2 < this.nframes; ++i2) {
                                this.speexDecoder.processData(false);
                            }
                        }
                        if ((decsize = this.speexDecoder.getProcessedData(decdat, 0)) > 0) {
                            writer.writePacket(decdat, 0, decsize);
                        }
                        ++packetNo;
                    }
                    if (chksum == origchksum) continue;
                    throw new IOException("Ogg CheckSums do not match");
                }
                if (packetNo == 0) {
                    if (this.srcFormat == 2) {
                        dis.readFully(header, 0, 12);
                        if (!"RIFF".equals(new String(header, 0, 4)) && !"WAVE".equals(new String(header, 8, 4))) {
                            System.err.println("Not a WAVE file");
                            return;
                        }
                        dis.readFully(header, 0, 8);
                        String chunk = new String(header, 0, 4);
                        int size = JSpeexDec.readInt(header, 4);
                        while (!chunk.equals("data")) {
                            dis.readFully(header, 0, size);
                            if (chunk.equals("fmt ")) {
                                if (JSpeexDec.readShort(header, 0) != -24311) {
                                    System.err.println("Not a Wave Speex file");
                                    return;
                                }
                                this.channels = JSpeexDec.readShort(header, 2);
                                this.sampleRate = JSpeexDec.readInt(header, 4);
                                bodybytes = JSpeexDec.readShort(header, 12);
                                if (JSpeexDec.readShort(header, 16) < 82) {
                                    System.err.println("Possibly corrupt Speex Wave file.");
                                    return;
                                }
                                this.readSpeexHeader(header, 20, 80);
                                if (this.printlevel <= 0) {
                                    System.out.println("File Format: Wave Speex");
                                    System.out.println("Sample Rate: " + this.sampleRate);
                                    System.out.println("Channels: " + this.channels);
                                    System.out.println("Encoder mode: " + (this.mode == 0 ? "Narrowband" : (this.mode == 1 ? "Wideband" : "UltraWideband")));
                                    System.out.println("Frames per packet: " + this.nframes);
                                }
                            }
                            dis.readFully(header, 0, 8);
                            chunk = new String(header, 0, 4);
                            size = JSpeexDec.readInt(header, 4);
                        }
                        if (this.printlevel <= 0) {
                            System.out.println("Data size: " + size);
                        }
                    } else {
                        if (this.printlevel <= 0) {
                            System.out.println("File Format: Raw Speex");
                            System.out.println("Sample Rate: " + this.sampleRate);
                            System.out.println("Channels: " + this.channels);
                            System.out.println("Encoder mode: " + (this.mode == 0 ? "Narrowband" : (this.mode == 1 ? "Wideband" : "UltraWideband")));
                            System.out.println("Frames per packet: " + this.nframes);
                        }
                        this.speexDecoder.init(this.mode, this.sampleRate, this.channels, this.enhanced);
                        if (!this.vbr) {
                            switch (this.mode) {
                                case 0: {
                                    bodybytes = NbEncoder.NB_FRAME_SIZE[NbEncoder.NB_QUALITY_MAP[this.quality]];
                                    break;
                                }
                                case 1: {
                                    bodybytes = SbEncoder.NB_FRAME_SIZE[SbEncoder.NB_QUALITY_MAP[this.quality]];
                                    bodybytes += SbEncoder.SB_FRAME_SIZE[SbEncoder.WB_QUALITY_MAP[this.quality]];
                                    break;
                                }
                                case 2: {
                                    bodybytes = SbEncoder.NB_FRAME_SIZE[SbEncoder.NB_QUALITY_MAP[this.quality]];
                                    bodybytes += SbEncoder.SB_FRAME_SIZE[SbEncoder.WB_QUALITY_MAP[this.quality]];
                                    bodybytes += SbEncoder.SB_FRAME_SIZE[SbEncoder.UWB_QUALITY_MAP[this.quality]];
                                    break;
                                }
                                default: {
                                    throw new IOException("Illegal mode encoundered.");
                                }
                            }
                            bodybytes = bodybytes + 7 >> 3;
                        } else {
                            bodybytes = 0;
                        }
                    }
                    if (this.destFormat == 2) {
                        writer = new PcmWaveWriter(this.sampleRate, this.channels);
                        if (this.printlevel <= 0) {
                            System.out.println("");
                            System.out.println("Output File: " + destPath);
                            System.out.println("File Format: PCM Wave");
                            System.out.println("Perceptual Enhancement: " + this.enhanced);
                        }
                    } else {
                        writer = new RawWriter();
                        if (this.printlevel <= 0) {
                            System.out.println("");
                            System.out.println("Output File: " + destPath);
                            System.out.println("File Format: Raw Audio");
                            System.out.println("Perceptual Enhancement: " + this.enhanced);
                        }
                    }
                    writer.open(destPath);
                    writer.writeHeader(null);
                    ++packetNo;
                    continue;
                }
                dis.readFully(payload, 0, bodybytes);
                if (this.loss > 0 && random.nextInt(100) < this.loss) {
                    this.speexDecoder.processData(null, 0, bodybytes);
                    for (i = 1; i < this.nframes; ++i) {
                        this.speexDecoder.processData(true);
                    }
                } else {
                    this.speexDecoder.processData(payload, 0, bodybytes);
                    for (i = 1; i < this.nframes; ++i) {
                        this.speexDecoder.processData(false);
                    }
                }
                if ((decsize = this.speexDecoder.getProcessedData(decdat, 0)) > 0) {
                    writer.writePacket(decdat, 0, decsize);
                }
                ++packetNo;
            }
        }
        catch (EOFException eOFException) {
            writer.close();
            return;
        }
    }

    private boolean readSpeexHeader(@NotNull byte[] packet, int offset, int bytes) {
        if (bytes != 80) {
            System.out.println("Oooops");
            return false;
        }
        if (!"Speex   ".equals(new String(packet, offset, 8))) {
            return false;
        }
        this.mode = packet[40 + offset] & 0xFF;
        this.sampleRate = JSpeexDec.readInt(packet, offset + 36);
        this.channels = JSpeexDec.readInt(packet, offset + 48);
        this.nframes = JSpeexDec.readInt(packet, offset + 64);
        return this.speexDecoder.init(this.mode, this.sampleRate, this.channels, this.enhanced);
    }

    protected static int readInt(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | data[offset + 3] << 24;
    }

    protected static int readShort(byte[] data, int offset) {
        return data[offset] & 0xFF | data[offset + 1] << 8;
    }
}

