/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.tools;

import java.util.Arrays;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.Profile;
import net.sourceforge.jaad.aac.SampleFrequency;
import net.sourceforge.jaad.aac.filterbank.FilterBank;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.aac.syntax.Constants;
import net.sourceforge.jaad.aac.syntax.ICSInfo;
import net.sourceforge.jaad.aac.syntax.ICStream;

public class LTPrediction
implements Constants {
    private static final float[] CODEBOOK = new float[]{0.570829f, 0.696616f, 0.813004f, 0.911304f, 0.9849f, 1.067894f, 1.194601f, 1.369533f};
    private final int frameLength;
    private final int[] states;
    private int coef;
    private int lag;
    private int lastBand;
    private boolean lagUpdate;
    private boolean[] shortUsed;
    private boolean[] shortLagPresent;
    private boolean[] longUsed;
    private int[] shortLag;

    public LTPrediction(int frameLength) {
        this.frameLength = frameLength;
        this.states = new int[4 * frameLength];
    }

    public void decode(BitStream in, ICSInfo info, Profile profile) throws AACException {
        this.lag = 0;
        if (profile.equals((Object)Profile.AAC_LD)) {
            this.lagUpdate = in.readBool();
            if (this.lagUpdate) {
                this.lag = in.readBits(10);
            }
        } else {
            this.lag = in.readBits(11);
        }
        if (this.lag > this.frameLength << 1) {
            throw new AACException("LTP lag too large: " + this.lag);
        }
        this.coef = in.readBits(3);
        int windowCount = info.getWindowCount();
        if (info.isEightShortFrame()) {
            this.shortUsed = new boolean[windowCount];
            this.shortLagPresent = new boolean[windowCount];
            this.shortLag = new int[windowCount];
            for (int w = 0; w < windowCount; ++w) {
                this.shortUsed[w] = in.readBool();
                if (!this.shortUsed[w]) continue;
                this.shortLagPresent[w] = in.readBool();
                if (!this.shortLagPresent[w]) continue;
                this.shortLag[w] = in.readBits(4);
            }
        } else {
            this.lastBand = Math.min(info.getMaxSFB(), 40);
            this.longUsed = new boolean[this.lastBand];
            for (int i = 0; i < this.lastBand; ++i) {
                this.longUsed[i] = in.readBool();
            }
        }
    }

    public void setPredictionUnused(int sfb) {
        if (this.longUsed != null) {
            this.longUsed[sfb] = false;
        }
    }

    public void process(ICStream ics, float[] data, FilterBank filterBank, SampleFrequency sf) {
        ICSInfo info = ics.getInfo();
        if (!info.isEightShortFrame()) {
            int samples = this.frameLength << 1;
            float[] in = new float[2048];
            float[] out = new float[2048];
            for (int i = 0; i < samples; ++i) {
                in[i] = (float)this.states[samples + i - this.lag] * CODEBOOK[this.coef];
            }
            filterBank.processLTP(info.getWindowSequence(), info.getWindowShape(1), info.getWindowShape(0), in, out);
            if (ics.isTNSDataPresent()) {
                ics.getTNS().process(ics, out, sf, true);
            }
            int[] swbOffsets = info.getSWBOffsets();
            int swbOffsetMax = info.getSWBOffsetMax();
            for (int sfb = 0; sfb < this.lastBand; ++sfb) {
                if (!this.longUsed[sfb]) continue;
                int low = swbOffsets[sfb];
                int high = Math.min(swbOffsets[sfb + 1], swbOffsetMax);
                for (int bin = low; bin < high; ++bin) {
                    int n = bin;
                    data[n] = data[n] + out[bin];
                }
            }
        }
    }

    public void updateState(float[] time, float[] overlap, Profile profile) {
        if (profile.equals((Object)Profile.AAC_LD)) {
            for (int i = 0; i < this.frameLength; ++i) {
                this.states[i] = this.states[i + this.frameLength];
                this.states[this.frameLength + i] = this.states[i + this.frameLength * 2];
                this.states[this.frameLength * 2 + i] = Math.round(time[i]);
                this.states[this.frameLength * 3 + i] = Math.round(overlap[i]);
            }
        } else {
            for (int i = 0; i < this.frameLength; ++i) {
                this.states[i] = this.states[i + this.frameLength];
                this.states[this.frameLength + i] = Math.round(time[i]);
                this.states[this.frameLength * 2 + i] = Math.round(overlap[i]);
            }
        }
    }

    public static boolean isLTPProfile(Profile profile) {
        return profile.equals((Object)Profile.AAC_LTP) || profile.equals((Object)Profile.ER_AAC_LTP) || profile.equals((Object)Profile.AAC_LD);
    }

    public void copy(LTPrediction ltp) {
        System.arraycopy(ltp.states, 0, this.states, 0, this.states.length);
        this.coef = ltp.coef;
        this.lag = ltp.lag;
        this.lastBand = ltp.lastBand;
        this.lagUpdate = ltp.lagUpdate;
        this.shortUsed = Arrays.copyOf(ltp.shortUsed, ltp.shortUsed.length);
        this.shortLagPresent = Arrays.copyOf(ltp.shortLagPresent, ltp.shortLagPresent.length);
        this.shortLag = Arrays.copyOf(ltp.shortLag, ltp.shortLag.length);
        this.longUsed = Arrays.copyOf(ltp.longUsed, ltp.longUsed.length);
    }
}

