/*
 * Decompiled with CFR 0.152.
 */
package org.aucom.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import org.aucom.sound.AudioQuality;
import org.aucom.sound.Microphone;
import org.aucom.test.NumberUtil;
import org.bytebuffer.ByteBuffer;

public class FrequencyTest {
    static final NumberFormat nf = new DecimalFormat("#0.0");
    static final File stats = new File("/home/martin/Testings/AudioTesting/stats.txt");

    public static void main(String[] args) throws LineUnavailableException, IOException {
        stats.createNewFile();
        AudioFormat format = AudioQuality.VOICE;
        Microphone microphone = new Microphone(format);
        microphone.open();
        float frameRate = format.getFrameRate();
        int sampleSizeBytes = format.getSampleSizeInBits() / 8;
        int secBytes = (int)(frameRate * (float)sampleSizeBytes);
        System.out.println("SecBytes: " + secBytes);
        ByteBuffer buffer = new ByteBuffer();
        System.out.println("Read started!");
        for (int i = 0; i < 10; ++i) {
            buffer.addFrom(microphone.readAudio(secBytes / 10));
        }
        System.out.println("Read finished!");
        microphone.close();
        FrequencyTest.saveData(buffer.drain());
    }

    public static void saveData(byte[] bytes) throws IOException {
        Files.write(stats.toPath(), Arrays.toString(bytes).getBytes(), StandardOpenOption.WRITE);
    }

    public static void printFloats(byte[] bytes) throws IOException {
        double divisor = 1.0E156;
        StringBuilder sbBytes = new StringBuilder();
        for (int i = 0; i < bytes.length; i += 8) {
            double data = Double.longBitsToDouble(NumberUtil.bytesToLong(Arrays.copyOfRange(bytes, i, i + 8)));
            sbBytes.append(nf.format(data / divisor)).append(' ');
        }
        sbBytes.deleteCharAt(sbBytes.length() - 1);
        sbBytes.append('\n');
        Files.write(stats.toPath(), sbBytes.toString().getBytes(), StandardOpenOption.APPEND);
    }
}

