/*
 * Decompiled with CFR 0.152.
 */
package org.bytebuffer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.RandomAccess;
import java.util.function.Predicate;

public class ByteBuffer
implements RandomAccess,
Cloneable,
Serializable {
    private byte[] array;
    private int size;
    private int capacity;
    private static final int DEFAULT_CAPACITY = 1024;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int MAX_CAPACITY = 0x3200000;
    private static final long serialVersionUID = 100L;

    public ByteBuffer() {
        this(1024);
    }

    public ByteBuffer(int capacity) {
        this.array = capacity <= 1024 ? new byte[1024] : new byte[capacity];
        this.size = 0;
        this.capacity = this.array.length;
    }

    public ByteBuffer(byte[] array) {
        this.array = array;
        this.size = this.capacity = array.length;
    }

    public ByteBuffer(byte[] array, int start, int end) {
        this.array = new byte[end - start];
        this.capacity = array.length;
        this.addFrom(array, start, end);
    }

    private void updateCapacity() {
        this.capacity = this.array.length;
    }

    private byte[] createArray(int size) {
        return new byte[size];
    }

    private void grow(int minCapacity) {
        int newCapacity = this.capacity + (this.capacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = 0x7FFFFFF7;
        }
        byte[] newArray = new byte[newCapacity];
        System.arraycopy(this.array, 0, newArray, 0, this.size);
        this.array = newArray;
        this.capacity = newCapacity;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.capacity) {
            this.grow(minCapacity);
        }
    }

    private void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException(index + "");
        }
    }

    private void checkCapacity() {
        if (this.size + 1 > this.capacity) {
            this.grow(this.size + 1);
        }
    }

    private void checkMemory() {
        long freeMem = Runtime.getRuntime().freeMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory - freeMem <= 80000000L) {
            System.gc();
        }
    }

    public boolean anyMatch(Predicate<Byte> predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.array[i])) continue;
            return true;
        }
        return false;
    }

    public void cut(int index) {
        if (index == this.size) {
            this.clear();
            return;
        }
        ByteBuffer buff = new ByteBuffer(new byte[1024]);
        for (int i = index; i < this.size; ++i) {
            buff.add(this.array[i]);
        }
        this.array = buff.array;
        this.capacity = this.array.length;
        this.size -= index;
    }

    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public byte[] toArray() {
        byte[] buffCopy = new byte[this.size];
        System.arraycopy(this.array, 0, buffCopy, 0, this.size);
        return buffCopy;
    }

    public byte[] drain() {
        byte[] bytes = this.toArray();
        this.array = new byte[1024];
        this.size = 0;
        return bytes;
    }

    public void removeAt(int start, int end) {
        int i;
        ByteBuffer newBuff = new ByteBuffer();
        for (i = 0; i < start; ++i) {
            newBuff.add(this.array[i]);
        }
        for (i = end + 1; i < this.size; ++i) {
            newBuff.add(this.array[i]);
        }
        this.array = newBuff.array;
        this.size = newBuff.size;
        this.capacity = this.array.length;
    }

    public int read(byte[] b, int off, int len) {
        int retur;
        if (len > b.length) {
            len = b.length;
        }
        int maxIndex = off;
        for (int i = 0; i < len; ++i) {
            b[i] = this.array[i + off];
            ++maxIndex;
        }
        int n = retur = this.capacity >= 0x3200000 ? -2 : len - off;
        if (retur == -2) {
            this.removeAt(0, maxIndex);
        }
        return retur;
    }

    public byte[] read(int start, int len) {
        if (this.size - start < len) {
            len = this.size - start;
        }
        ByteBuffer buffer = new ByteBuffer();
        for (int i = start; i < len; ++i) {
            buffer.add(this.array[i]);
        }
        return buffer.toArray();
    }

    public byte[] read(int start) {
        if (start < 0 || start >= this.size) {
            return null;
        }
        ByteBuffer buff = new ByteBuffer();
        for (int i = start; i < this.size; ++i) {
            buff.add(this.array[i]);
        }
        return buff.toArray();
    }

    public byte[] getRawArray() {
        return this.array;
    }

    public LinkedList<ByteBuffer> divide(int divitionSize) {
        LinkedList<ByteBuffer> listBuffers = new LinkedList<ByteBuffer>();
        ByteBuffer buff = new ByteBuffer();
        boolean added = false;
        for (int i = 0; i < this.size; ++i) {
            added = false;
            if (i >= divitionSize && i % divitionSize == 0) {
                listBuffers.add(buff);
                added = true;
                buff = new ByteBuffer();
                if (i == this.size - 1) {
                    added = false;
                }
            }
            buff.add(this.array[i]);
        }
        if (!added) {
            listBuffers.add(buff);
        }
        return listBuffers;
    }

    public void add(byte e) {
        this.ensureCapacity(this.size + 1);
        this.array[this.size++] = e;
    }

    public void add(int e) {
        this.add((byte)e);
    }

    public void addFrom(byte[] array) {
        this.addFrom(array, 0, array.length);
    }

    public void addFrom(ByteBuffer buffer) {
        this.addFrom(buffer.toArray());
    }

    public void addFrom(ByteBuffer buffer, int start, int len) {
        this.addFrom(buffer.toArray(), start, len);
    }

    public void addFrom(byte[] array, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.add(array[i]);
        }
    }

    public void clear() {
        this.array = null;
        this.array = new byte[1024];
        this.capacity = 0;
        this.size = 0;
    }

    public byte getFirst() {
        this.checkIndex(0);
        return this.array[0];
    }

    public byte pollFirst() {
        this.checkIndex(0);
        byte b = this.array[0];
        ByteBuffer buff = new ByteBuffer(new byte[this.array.length]);
        buff.addFrom(this.array, 1, this.size);
        this.array = buff.array;
        this.capacity = this.array.length;
        --this.size;
        return b;
    }

    public byte getLast() {
        this.checkIndex(this.size - 1);
        return this.array[this.size - 1];
    }

    public byte get(int index) {
        this.checkIndex(index);
        return this.array[index];
    }

    public byte set(int index, byte element) {
        this.checkIndex(index);
        byte e = this.get(index);
        this.array[index] = element;
        return e;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

