/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.util;

import java.io.File;
import java.text.DecimalFormat;
import org.muplayer.audio.Player;
import org.muplayer.audio.Track;

public class PlayerInfo {
    private Track current;
    private File trackFolder;
    private File rootFolder;
    private float gain;
    private int songsCount;
    private int foldersCount;

    public PlayerInfo(Player player) {
        this.current = player.getCurrent();
        this.trackFolder = this.current == null ? null : this.current.getDataSource().getParentFile();
        this.rootFolder = player.getRootFolder();
        this.gain = player.getGain();
        this.songsCount = player.getSongsCount();
        this.foldersCount = player.getFoldersCount();
    }

    public Track getCurrentTrack() {
        return this.current;
    }

    public String getCurrentTrackTitle() {
        return this.current == null ? "Title Unknown" : this.current.getTitle();
    }

    public String getCurrentTrackFormat() {
        if (this.current == null) {
            return "Track Unknown";
        }
        String currentClass = this.current.getClass().getSimpleName();
        return currentClass.substring(0, currentClass.length() - 5).toLowerCase();
    }

    public File getTrackFolder() {
        return this.trackFolder;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public float getVolume() {
        return this.gain;
    }

    public int getSongsCount() {
        return this.songsCount;
    }

    public int getFoldersCount() {
        return this.foldersCount;
    }

    public String toString() {
        return "{\n\t" + "Track: " + this.getCurrentTrackTitle() + ",\n\t" + "Track Format: " + this.getCurrentTrackFormat() + ",\n\t" + "Track Folder: " + (this.trackFolder == null ? "Unknown" : this.trackFolder.getPath()) + ",\n\t" + "Root Folder: " + (this.rootFolder == null ? "Unknown" : this.rootFolder.getPath()) + ",\n\t" + "Volume: " + new DecimalFormat("#0.0").format(this.gain) + ",\n\t" + "Songs Count: " + this.songsCount + ",\n\t" + "Folder Count: " + this.foldersCount + "\n}";
    }
}

