/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.system;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import org.muplayer.system.AudioUtil;

public class LineUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMasterOutputVolume(float value) {
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("Volume can only be set to a value from 0 to 1. Given value is illegal: " + value);
        }
        Line line = LineUtil.getMasterOutputLine();
        if (line == null) {
            throw new RuntimeException("Master output port not found");
        }
        boolean opened = LineUtil.open(line);
        try {
            FloatControl control = LineUtil.getVolumeControl(line);
            if (control == null) {
                throw new RuntimeException("Volume control not found in master port: " + LineUtil.toString(line));
            }
            control.setValue(value);
        }
        finally {
            if (opened) {
                line.close();
            }
        }
    }

    public static void setFormattedMasterVolume(float volume) {
        FloatControl volumeControl = LineUtil.getReadyVolumeControl();
        volumeControl.setValue(AudioUtil.convertVolRangeToLineRange(volume, volumeControl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Float getMasterOutputVolume() {
        Line line = LineUtil.getMasterOutputLine();
        if (line == null) {
            return null;
        }
        boolean opened = LineUtil.open(line);
        try {
            FloatControl control = LineUtil.getVolumeControl(line);
            if (control == null) {
                Float f = null;
                return f;
            }
            Float f = Float.valueOf(control.getValue());
            return f;
        }
        finally {
            if (opened) {
                line.close();
            }
        }
    }

    public static FloatControl getReadyVolumeControl() {
        Line master = LineUtil.getMasterOutputLine();
        try {
            master.open();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        return LineUtil.getVolumeControl(master);
    }

    public static float getFormattedMasterVolume() {
        FloatControl volumeControl = LineUtil.getReadyVolumeControl();
        return AudioUtil.convertLineRangeToVolRange(volumeControl.getValue(), volumeControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMasterOutputMute(boolean value) {
        Line line = LineUtil.getMasterOutputLine();
        if (line == null) {
            throw new RuntimeException("Master output port not found");
        }
        boolean opened = LineUtil.open(line);
        try {
            BooleanControl control = LineUtil.getMuteControl(line);
            if (control == null) {
                throw new RuntimeException("Mute control not found in master port: " + LineUtil.toString(line));
            }
            control.setValue(value);
        }
        finally {
            if (opened) {
                line.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean getMasterOutputMute() {
        Line line = LineUtil.getMasterOutputLine();
        if (line == null) {
            return null;
        }
        boolean opened = LineUtil.open(line);
        try {
            BooleanControl control = LineUtil.getMuteControl(line);
            if (control == null) {
                Boolean bl = null;
                return bl;
            }
            Boolean bl = control.getValue();
            return bl;
        }
        finally {
            if (opened) {
                line.close();
            }
        }
    }

    public static Line getMasterOutputLine() {
        for (Mixer mixer : LineUtil.getMixers()) {
            for (Line line : LineUtil.getAvailableOutputLines(mixer)) {
                if (!line.getLineInfo().toString().contains("Master")) continue;
                return line;
            }
        }
        return null;
    }

    public static FloatControl getVolumeControl(Line line) {
        if (!line.isOpen()) {
            throw new RuntimeException("Line is closed: " + LineUtil.toString(line));
        }
        return (FloatControl)LineUtil.findControl(FloatControl.Type.VOLUME, line.getControls());
    }

    public static BooleanControl getMuteControl(Line line) {
        if (!line.isOpen()) {
            throw new RuntimeException("Line is closed: " + LineUtil.toString(line));
        }
        return (BooleanControl)LineUtil.findControl(BooleanControl.Type.MUTE, line.getControls());
    }

    private static Control findControl(Control.Type type, Control ... controls) {
        if (controls == null || controls.length == 0) {
            return null;
        }
        for (Control control : controls) {
            CompoundControl compoundControl;
            Control member;
            if (control.getType().equals(type)) {
                return control;
            }
            if (!(control instanceof CompoundControl) || (member = LineUtil.findControl(type, (compoundControl = (CompoundControl)control).getMemberControls())) == null) continue;
            return member;
        }
        return null;
    }

    public static LinkedList<Mixer> getMixers() {
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        LinkedList<Mixer> mixers = new LinkedList<Mixer>();
        for (int i = 0; i < infos.length; ++i) {
            mixers.add(AudioSystem.getMixer(infos[i]));
        }
        return mixers;
    }

    public static List<Line> getAvailableOutputLines(Mixer mixer) {
        return LineUtil.getAvailableLines(mixer, mixer.getTargetLineInfo());
    }

    public static List<Line> getAvailableInputLines(Mixer mixer) {
        return LineUtil.getAvailableLines(mixer, mixer.getSourceLineInfo());
    }

    private static List<Line> getAvailableLines(Mixer mixer, Line.Info[] lineInfos) {
        ArrayList<Line> lines = new ArrayList<Line>(lineInfos.length);
        for (Line.Info lineInfo : lineInfos) {
            Line line = LineUtil.getLineIfAvailable(mixer, lineInfo);
            if (line == null) continue;
            lines.add(line);
        }
        return lines;
    }

    public static Line getLineIfAvailable(Mixer mixer, Line.Info lineInfo) {
        try {
            return mixer.getLine(lineInfo);
        }
        catch (LineUnavailableException ex) {
            return null;
        }
    }

    public static void getLineInfo(Line line, StringBuilder sb, boolean opened) {
        for (Control control : line.getControls()) {
            sb.append("    Control: ").append(LineUtil.toString(control)).append("\n");
            if (!(control instanceof CompoundControl)) continue;
            CompoundControl compoundControl = (CompoundControl)control;
            for (Control subControl : compoundControl.getMemberControls()) {
                sb.append("      Sub-Control: ").append(LineUtil.toString(subControl)).append("\n");
            }
        }
        if (opened) {
            line.close();
        }
    }

    public static String getHierarchyInfo() {
        StringBuilder sb = new StringBuilder();
        for (Mixer mixer : LineUtil.getMixers()) {
            boolean opened;
            sb.append("Mixer: ").append(LineUtil.toString(mixer)).append("\n");
            for (Line line : LineUtil.getAvailableOutputLines(mixer)) {
                sb.append("  OUT: ").append(LineUtil.toString(line)).append("\n");
                opened = LineUtil.open(line);
                LineUtil.getLineInfo(line, sb, opened);
            }
            for (Line line : LineUtil.getAvailableOutputLines(mixer)) {
                sb.append("  IN: ").append(LineUtil.toString(line)).append("\n");
                opened = LineUtil.open(line);
                LineUtil.getLineInfo(line, sb, opened);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static boolean open(Line line) {
        if (line.isOpen()) {
            return false;
        }
        try {
            line.open();
        }
        catch (LineUnavailableException ex) {
            return false;
        }
        return true;
    }

    public static String toString(Control control) {
        if (control == null) {
            return null;
        }
        return control.toString() + " (" + control.getType().toString() + ")";
    }

    public static String toString(Line line) {
        if (line == null) {
            return null;
        }
        Line.Info info = line.getLineInfo();
        return info.toString();
    }

    public static String toString(Mixer mixer) {
        if (mixer == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Mixer.Info info = mixer.getMixerInfo();
        sb.append(info.getName());
        sb.append(" (").append(info.getDescription()).append(")");
        sb.append(mixer.isOpen() ? " [open]" : " [closed]");
        return sb.toString();
    }
}

