/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jetbrains.annotations.NotNull;
import org.xiph.speex.AudioFileWriter;

public class PcmWaveWriter
extends AudioFileWriter {
    public static final short WAVE_FORMAT_PCM = 1;
    public static final short WAVE_FORMAT_SPEEX = -24311;
    public static final int[][][] WAVE_FRAME_SIZES = new int[][][]{new int[][]{{8, 8, 8, 1, 1, 2, 2, 2, 2, 2, 2}, {2, 1, 1, 7, 7, 8, 8, 8, 8, 3, 3}}, new int[][]{{8, 8, 8, 2, 1, 1, 2, 2, 2, 2, 2}, {1, 2, 2, 8, 7, 6, 3, 3, 3, 3, 3}}, new int[][]{{8, 8, 8, 1, 2, 2, 1, 1, 1, 1, 1}, {2, 1, 1, 7, 8, 3, 6, 6, 5, 5, 5}}};
    public static final int[][][] WAVE_BITS_PER_FRAME = new int[][][]{new int[][]{{43, 79, 119, 160, 160, 220, 220, 300, 300, 364, 492}, {60, 96, 136, 177, 177, 237, 237, 317, 317, 381, 509}}, new int[][]{{79, 115, 155, 196, 256, 336, 412, 476, 556, 684, 844}, {96, 132, 172, 213, 273, 353, 429, 493, 573, 701, 861}}, new int[][]{{83, 151, 191, 232, 292, 372, 448, 512, 592, 720, 880}, {100, 168, 208, 249, 309, 389, 465, 529, 609, 737, 897}}};
    private RandomAccessFile raf;
    private int mode;
    private int quality;
    private int sampleRate;
    private int channels;
    private int nframes;
    private boolean vbr;
    private int size = 0;
    private boolean isPCM;

    public PcmWaveWriter() {
    }

    public PcmWaveWriter(int sampleRate, int channels) {
        this();
        this.setPCMFormat(sampleRate, channels);
    }

    public PcmWaveWriter(int mode, int quality, int sampleRate, int channels, int nframes, boolean vbr) {
        this();
        this.setSpeexFormat(mode, quality, sampleRate, channels, nframes, vbr);
    }

    private void setPCMFormat(int sampleRate, int channels) {
        this.channels = channels;
        this.sampleRate = sampleRate;
        this.isPCM = true;
    }

    private void setSpeexFormat(int mode, int quality, int sampleRate, int channels, int nframes, boolean vbr) {
        this.mode = mode;
        this.quality = quality;
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.nframes = nframes;
        this.vbr = vbr;
        this.isPCM = false;
    }

    public void close() throws IOException {
        this.raf.seek(4L);
        int fileLength = (int)this.raf.length() - 8;
        PcmWaveWriter.writeInt(this.raf, fileLength);
        this.raf.seek(40L);
        PcmWaveWriter.writeInt(this.raf, this.size);
        this.raf.close();
    }

    public void open(@NotNull File file) throws IOException {
        file.delete();
        this.raf = new RandomAccessFile(file, "rw");
        this.size = 0;
    }

    public void open(@NotNull String filename) throws IOException {
        this.open(new File(filename));
    }

    public void writeHeader(@NotNull String comment) throws IOException {
        byte[] chkid = "RIFF".getBytes();
        this.raf.write(chkid, 0, chkid.length);
        PcmWaveWriter.writeInt(this.raf, 0);
        chkid = "WAVE".getBytes();
        this.raf.write(chkid, 0, chkid.length);
        chkid = "fmt ".getBytes();
        this.raf.write(chkid, 0, chkid.length);
        if (this.isPCM) {
            PcmWaveWriter.writeInt(this.raf, 16);
            PcmWaveWriter.writeShort(this.raf, (short)1);
            PcmWaveWriter.writeShort(this.raf, (short)this.channels);
            PcmWaveWriter.writeInt(this.raf, this.sampleRate);
            PcmWaveWriter.writeInt(this.raf, this.sampleRate * this.channels * 2);
            PcmWaveWriter.writeShort(this.raf, (short)(this.channels * 2));
            PcmWaveWriter.writeShort(this.raf, (short)16);
        } else {
            int length = comment.length();
            PcmWaveWriter.writeInt(this.raf, (int)((short)(100 + length)));
            PcmWaveWriter.writeShort(this.raf, (short)-24311);
            PcmWaveWriter.writeShort(this.raf, (short)this.channels);
            PcmWaveWriter.writeInt(this.raf, this.sampleRate);
            PcmWaveWriter.writeInt(this.raf, PcmWaveWriter.calculateEffectiveBitrate(this.mode, this.channels, this.quality) + 7 >> 3);
            PcmWaveWriter.writeShort(this.raf, (short)PcmWaveWriter.calculateBlockSize(this.mode, this.channels, this.quality));
            PcmWaveWriter.writeShort(this.raf, (short)this.quality);
            PcmWaveWriter.writeShort(this.raf, (short)(82 + length));
            this.raf.writeByte(1);
            this.raf.writeByte(0);
            this.raf.write(PcmWaveWriter.buildSpeexHeader(this.sampleRate, this.mode, this.channels, this.vbr, this.nframes));
            this.raf.writeBytes(comment);
        }
        chkid = "data".getBytes();
        this.raf.write(chkid, 0, chkid.length);
        PcmWaveWriter.writeInt(this.raf, 0);
    }

    public void writePacket(@NotNull byte[] data, int offset, int len) throws IOException {
        this.raf.write(data, offset, len);
        this.size += len;
    }

    private static int calculateEffectiveBitrate(int mode, int channels, int quality) {
        return (WAVE_FRAME_SIZES[mode - 1][channels - 1][quality] * WAVE_BITS_PER_FRAME[mode - 1][channels - 1][quality] + 7 >> 3) * 50 * 8 / WAVE_BITS_PER_FRAME[mode - 1][channels - 1][quality];
    }

    private static int calculateBlockSize(int mode, int channels, int quality) {
        return WAVE_FRAME_SIZES[mode - 1][channels - 1][quality] * WAVE_BITS_PER_FRAME[mode - 1][channels - 1][quality] + 7 >> 3;
    }
}

