/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.Parser;
import sun.tools.jstat.ParserException;

public class OptionLister {
    private static final boolean debug = false;
    private URL[] sources;

    public OptionLister(URL[] uRLArray) {
        this.sources = uRLArray;
    }

    public void print(PrintStream printStream) {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                OptionFormat optionFormat = (OptionFormat)object;
                OptionFormat optionFormat2 = (OptionFormat)object2;
                return optionFormat.getName().compareTo(optionFormat2.getName());
            }
        };
        TreeSet treeSet = new TreeSet(comparator);
        for (int i = 0; i < this.sources.length; ++i) {
            try {
                Object object = this.sources[i];
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
                Set set = new Parser(bufferedReader).parseOptions();
                treeSet.addAll(set);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (ParserException parserException) {
                System.err.println(this.sources[i] + ": " + parserException.getMessage());
                System.err.println("Parsing of " + this.sources[i] + " aborted");
            }
        }
        for (Object object : treeSet) {
            if (((OptionFormat)object).getName().compareTo("timestamp") == 0) continue;
            printStream.println("-" + ((OptionFormat)object).getName());
        }
    }
}

