/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.AuxGen;
import com.sun.tools.corba.se.idl.toJavaPortable.MethodGen24;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.util.Hashtable;
import java.util.Vector;

public class DefaultFactory
implements AuxGen {
    protected Hashtable symbolTable;
    protected SymtabEntry entry;
    protected GenFileStream stream;
    protected String factoryClass;
    protected String factoryInterface;
    protected String factoryType;
    protected String implType;

    public void generate(Hashtable hashtable, SymtabEntry symtabEntry) {
        this.symbolTable = hashtable;
        this.entry = symtabEntry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.factoryClass = this.entry.name() + "DefaultFactory";
        this.factoryInterface = this.entry.name() + "ValueFactory";
        this.factoryType = Util.javaName(this.entry);
        this.implType = this.entry.name() + "Impl";
    }

    protected boolean hasFactoryMethods() {
        Vector vector = ((ValueEntry)this.entry).initializers();
        return vector != null && vector.size() > 0;
    }

    protected void openStream() {
        this.stream = Util.stream(this.entry, "DefaultFactory.java");
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.entry, (short)0);
        Util.writeProlog(this.stream, this.stream.name());
        if (this.entry.comment() != null) {
            this.entry.comment().generate("", this.stream);
        }
        this.stream.print("public class " + this.factoryClass + " implements ");
        if (this.hasFactoryMethods()) {
            this.stream.print(this.factoryInterface);
        } else {
            this.stream.print("org.omg.CORBA.portable.ValueFactory");
        }
        this.stream.println(" {");
    }

    protected void writeBody() {
        this.writeFactoryMethods();
        this.stream.println();
        this.writeReadValue();
    }

    protected void writeFactoryMethods() {
        Vector vector = ((ValueEntry)this.entry).initializers();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                MethodEntry methodEntry = (MethodEntry)vector.elementAt(i);
                methodEntry.valueMethod(true);
                ((MethodGen24)methodEntry.generator()).defaultFactoryMethod(this.symbolTable, methodEntry, this.stream);
            }
        }
    }

    protected void writeReadValue() {
        this.stream.println("  public java.io.Serializable read_value (org.omg.CORBA_2_3.portable.InputStream is)");
        this.stream.println("  {");
        this.stream.println("    return is.read_value(new " + this.implType + " ());");
        this.stream.println("  }");
    }

    protected void writeClosing() {
        this.stream.println('}');
    }

    protected void closeStream() {
        this.stream.close();
    }
}

