/*
 * Decompiled with CFR 0.152.
 */
package org.aucom.sound;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class DigitalAudioSystem {
    private ArrayList<Mixer> listMixers;

    public DigitalAudioSystem() {
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        this.listMixers = new ArrayList();
        for (int i = 0; i < mixerInfo.length; ++i) {
            this.listMixers.add(AudioSystem.getMixer(mixerInfo[i]));
        }
    }

    private void addDataToList(Object[] data, List list) {
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                list.add(data[i]);
            }
        }
    }

    private boolean isLineSupported(Mixer mixer, Class<? extends Line> infoClass) {
        return mixer.isLineSupported(new Line.Info(infoClass));
    }

    private Line.Info[] findLines(Mixer mixer, Class<? extends Line> infoClass) {
        if (this.isLineSupported(mixer, infoClass)) {
            int i;
            Line.Info[] sourceLineInfo = mixer.getSourceLineInfo(new Line.Info(infoClass));
            Line.Info[] targetLineInfo = mixer.getTargetLineInfo(new Line.Info(infoClass));
            Line.Info[] result = new Line.Info[sourceLineInfo.length + targetLineInfo.length];
            int linesCount = 0;
            if (sourceLineInfo.length > 0) {
                for (i = 0; i < sourceLineInfo.length; ++i) {
                    result[linesCount++] = sourceLineInfo[i];
                }
            }
            if (targetLineInfo.length > 0) {
                for (i = 0; i < targetLineInfo.length; ++i) {
                    result[linesCount++] = targetLineInfo[i];
                }
            }
            return result;
        }
        return null;
    }

    public Mixer getMixer(String name) {
        return this.listMixers.parallelStream().filter(mixer -> mixer.getMixerInfo().getName().equals(name)).findFirst().orElse(null);
    }

    public ArrayList<Line> getMixerLines(Mixer mixer) {
        return this.getMixerLines(mixer.getMixerInfo().getName());
    }

    public ArrayList<Line> getMixerLines(String mixerName) {
        Mixer mixer = this.getMixer(mixerName);
        ArrayList<Line> listLines = new ArrayList<Line>();
        listLines.addAll(this.getMixerTargetLines(mixer.getMixerInfo().getName()));
        listLines.addAll(this.getMixerSourceLines(mixer.getMixerInfo().getName()));
        listLines.addAll(this.getMixerPorts(mixer.getMixerInfo().getName()));
        listLines.addAll(this.getMixerClips(mixer.getMixerInfo().getName()));
        return listLines;
    }

    public ArrayList<SourceDataLine> getMixerSourceLines(Mixer mixer) {
        return this.getMixerSourceLines(mixer.getMixerInfo().getName());
    }

    public ArrayList<SourceDataLine> getMixerSourceLines(String mixerName) {
        Line.Info[] lineInfos;
        Mixer mixer = this.getMixer(mixerName);
        ArrayList<SourceDataLine> listLines = new ArrayList<SourceDataLine>();
        if (mixer != null && (lineInfos = this.findLines(mixer, SourceDataLine.class)) != null) {
            for (int i = 0; i < lineInfos.length; ++i) {
                try {
                    listLines.add((SourceDataLine)mixer.getLine(lineInfos[i]));
                    continue;
                }
                catch (LineUnavailableException e) {
                    e.printStackTrace();
                }
            }
        }
        return listLines;
    }

    public ArrayList<TargetDataLine> getMixerTargetLines(Mixer mixer) {
        return this.getMixerTargetLines(mixer.getMixerInfo().getName());
    }

    public ArrayList<TargetDataLine> getMixerTargetLines(String mixerName) {
        Line.Info[] lineInfos;
        Mixer mixer = this.getMixer(mixerName);
        ArrayList<TargetDataLine> listLines = new ArrayList<TargetDataLine>();
        if (mixer != null && (lineInfos = this.findLines(mixer, TargetDataLine.class)) != null) {
            for (int i = 0; i < lineInfos.length; ++i) {
                try {
                    listLines.add((TargetDataLine)mixer.getLine(lineInfos[i]));
                    continue;
                }
                catch (LineUnavailableException e) {
                    e.printStackTrace();
                }
            }
        }
        return listLines;
    }

    public ArrayList<Port> getMixerPorts(Mixer mixer) {
        return this.getMixerPorts(mixer.getMixerInfo().getName());
    }

    public ArrayList<Port> getMixerPorts(String mixerName) {
        Line.Info[] lineInfos;
        Mixer mixer = this.getMixer(mixerName);
        ArrayList<Port> listLines = new ArrayList<Port>();
        if (mixer != null && (lineInfos = this.findLines(mixer, Port.class)) != null) {
            for (int i = 0; i < lineInfos.length; ++i) {
                try {
                    listLines.add((Port)mixer.getLine(lineInfos[i]));
                    continue;
                }
                catch (LineUnavailableException e) {
                    e.printStackTrace();
                }
            }
        }
        return listLines;
    }

    public ArrayList<Clip> getMixerClips(Mixer mixer) {
        return this.getMixerClips(mixer.getMixerInfo().getName());
    }

    public ArrayList<Clip> getMixerClips(String mixerName) {
        Line.Info[] lineInfos;
        Mixer mixer = this.getMixer(mixerName);
        ArrayList<Clip> listLines = new ArrayList<Clip>();
        if (mixer != null && (lineInfos = this.findLines(mixer, Clip.class)) != null) {
            for (int i = 0; i < lineInfos.length; ++i) {
                try {
                    listLines.add((Clip)mixer.getLine(lineInfos[i]));
                    continue;
                }
                catch (LineUnavailableException e) {
                    e.printStackTrace();
                }
            }
        }
        return listLines;
    }

    public Port findPort(Mixer mixer, String portName, boolean input) {
        return this.findPort(mixer.getMixerInfo().getName(), portName, input);
    }

    public Port findPort(String mixerName, String portName, boolean input) {
        Mixer mixer = this.getMixer(mixerName);
        if (mixer == null) {
            return null;
        }
        ArrayList<Port> mixerPorts = this.getMixerPorts(mixerName);
        return mixerPorts.parallelStream().filter(p -> {
            String name = p.getLineInfo().toString().toLowerCase();
            boolean contains = name.contains(input ? "source" : "target");
            return contains && name.contains(portName.toLowerCase());
        }).findFirst().orElse(null);
    }

    private String[] getControlNames(Class<? extends Control.Type> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<String> listNames = new ArrayList<String>();
        Constructor<? extends Control.Type> constructor = clazz.getConstructor(String.class);
        constructor.setAccessible(true);
        Control.Type type = constructor.newInstance("test");
        for (int i = 0; i < declaredFields.length; ++i) {
            Field field = declaredFields[i];
            if (field.getModifiers() != 8) continue;
            listNames.add((String)field.get(null));
        }
        String[] array = new String[listNames.size()];
        return listNames.toArray(array);
    }

    public HashMap<Mixer, ArrayList<Line>> getCompleteMixers() {
        HashMap<Mixer, ArrayList<Line>> mapMixers = new HashMap<Mixer, ArrayList<Line>>();
        this.listMixers.forEach(mixer -> mapMixers.put((Mixer)mixer, this.getMixerLines((Mixer)mixer)));
        return mapMixers;
    }

    public ArrayList<Mixer> getMixers() {
        return this.listMixers;
    }
}

