/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.formats.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bytebuffer.ByteBuffer;

public class AudioDataOutputStream
extends OutputStream {
    private ByteBuffer byteBuffer;
    private boolean isClosed;

    public AudioDataOutputStream() {
        this(new ByteBuffer());
    }

    public AudioDataOutputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.isClosed = false;
    }

    ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed!");
        }
        for (int i = off; i < len; ++i) {
            this.byteBuffer.add(b[i]);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed!");
        }
        this.byteBuffer.add(b);
    }
}

