/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.util;

import java.util.ArrayList;
import org.muplayer.system.SysInfo;

public class AudioExtensions {
    public static final String MPEG = "mp3";
    public static final String OGG = "ogg";
    public static final String AAC = "aac";
    public static final String AC3 = "ac3";
    public static final String FLAC = "flac";
    public static final String WAVE = "wav";
    public static final String M4A = "m4a";
    public static final String AIFF = "aiff";
    public static final String AIFC = "aifc";
    public static final String AU = "au";
    public static final String SND = "snd";
    public static String[] SUPPORTEDEXTENSIONS = new String[0];

    public static String getFormatName(String fileName) {
        String[] split = fileName.trim().split("\\.");
        return split != null && split.length > 0 ? split[split.length - 1] : "";
    }

    static {
        ArrayList<String> listSupportedFormats = new ArrayList<String>();
        listSupportedFormats.add(MPEG);
        listSupportedFormats.add(OGG);
        listSupportedFormats.add(AAC);
        listSupportedFormats.add(AC3);
        listSupportedFormats.add(FLAC);
        listSupportedFormats.add(WAVE);
        listSupportedFormats.add(M4A);
        listSupportedFormats.add(SND);
        if (SysInfo.ISUNIX) {
            listSupportedFormats.add(AU);
        }
        if (SysInfo.ISMAC) {
            listSupportedFormats.add(AIFF);
            listSupportedFormats.add(AIFC);
        }
        int supportedSize = listSupportedFormats.size();
        SUPPORTEDEXTENSIONS = new String[supportedSize];
        for (int i = 0; i < supportedSize; ++i) {
            AudioExtensions.SUPPORTEDEXTENSIONS[i] = (String)listSupportedFormats.get(i);
        }
    }
}

