/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.muplayer.audio.util.AudioExtensions;

public class AudioUtil {
    private static final float MAX_VOL = 0.855f;
    private static final float MIN_VOL = -80.0f;
    public static final float VOL_RANGE = 80.855f;
    public static final float MiDDLE_VOL = 40.4275f;
    private static final float DEFAULT_MIN_VOL = 0.0f;
    private static final float DEFAULT_MAX_VOL = 100.0f;
    private static final float DEFAULT_VOL_RANGE = 100.0f;

    private static float convertVolRangeToLineRange(float volume, float minLineVol, float maxLineVol) {
        float volRange = maxLineVol - minLineVol;
        float volScale = 1.0f / (100.0f / volRange);
        float result = volume * volScale + minLineVol;
        return result < minLineVol ? minLineVol : (result > maxLineVol ? maxLineVol : result);
    }

    private static float convertLineRangeToVolRange(float volume, float minLineVol, float maxLineVol) {
        float volRange = maxLineVol - minLineVol;
        float volScale = 1.0f / (100.0f / volRange);
        float result = (volume - minLineVol) / volScale;
        return result < 0.0f ? 0.0f : (result > 100.0f ? 100.0f : result);
    }

    public static float convertVolRangeToLineRange(float volume) {
        return AudioUtil.convertVolRangeToLineRange(volume, -80.0f, 0.855f);
    }

    public static float convertLineRangeToVolRange(float volume) {
        return AudioUtil.convertLineRangeToVolRange(volume, -80.0f, 0.855f);
    }

    public static float convertVolRangeToLineRange(float volume, FloatControl control) {
        return AudioUtil.convertVolRangeToLineRange(volume, control.getMinimum(), control.getMaximum());
    }

    public static float convertLineRangeToVolRange(float volume, FloatControl control) {
        return AudioUtil.convertLineRangeToVolRange(volume, control.getMinimum(), control.getMaximum());
    }

    public static AudioInputStream instanceStream(AudioFileReader audioReader, Object source) throws IOException, UnsupportedAudioFileException {
        if (source instanceof URL) {
            return audioReader.getAudioInputStream((URL)source);
        }
        if (source instanceof InputStream) {
            return audioReader.getAudioInputStream((InputStream)source);
        }
        return audioReader.getAudioInputStream((File)source);
    }

    public static boolean isSupported(File track) {
        String trackName = track.getName();
        boolean isSupported = false;
        for (int i = 0; i < AudioExtensions.SUPPORTEDEXTENSIONS.length; ++i) {
            if (!trackName.endsWith(AudioExtensions.SUPPORTEDEXTENSIONS[i])) continue;
            isSupported = true;
            break;
        }
        return isSupported;
    }
}

