/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.tests.ontesting;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;
import net.sourceforge.jaad.mp4.MP4Container;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import net.sourceforge.jaad.mp4.api.Movie;
import net.sourceforge.jaad.mp4.api.Track;

public class TestAAC2 {
    public static void main(String[] args) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        String strTrack = "/home/martin/AudioTesting/audio/aac3.aac";
        File inputFile = new File(strTrack);
        AudioInputStream ais = TestAAC2.decodeAAC(inputFile);
        System.out.println("Decoded");
        File outFile = new File("/home/martin/AudioTesting/audio/waveout.wav");
        outFile.createNewFile();
        AudioSystem.write(ais, AudioFileFormat.Type.WAVE, outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AudioInputStream decodeAAC(File inputFile) throws AACException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AudioFormat audioFormat = null;
        try {
            ADTSDemultiplexer adts = new ADTSDemultiplexer(new FileInputStream(inputFile));
            Decoder dec = new Decoder(adts.getDecoderSpecificInfo());
            SampleBuffer buf = new SampleBuffer();
            while (true) {
                byte[] b;
                try {
                    b = adts.readNextFrame();
                }
                catch (Exception e) {
                    break;
                }
                dec.decodeFrame(b, buf);
                outputStream.write(buf.getData());
            }
            audioFormat = new AudioFormat(buf.getSampleRate(), buf.getBitsPerSample(), buf.getChannels(), true, buf.isBigEndian());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] outputStreamByteArray = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStreamByteArray);
        return new AudioInputStream(inputStream, audioFormat, outputStreamByteArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AudioInputStream decodeMP4(File inputFile) throws UnsupportedAudioFileException, IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AudioFormat audioFormat = null;
        try (RandomAccessFile randomAccessFile = null;){
            randomAccessFile = new RandomAccessFile(inputFile, "r");
            MP4Container cont = new MP4Container(randomAccessFile);
            Movie movie = cont.getMovie();
            List<Track> tracks = movie.getTracks(AudioTrack.AudioCodec.AAC);
            if (tracks.isEmpty()) {
                throw new UnsupportedAudioFileException("Movie does not contain any AAC track");
            }
            AudioTrack track = (AudioTrack)tracks.get(0);
            Decoder dec = new Decoder(track.getDecoderSpecificInfo());
            SampleBuffer buf = new SampleBuffer();
            while (track.hasMoreFrames()) {
                Frame frame = track.readNextFrame();
                dec.decodeFrame(frame.getData(), buf);
                outputStream.write(buf.getData());
            }
            audioFormat = new AudioFormat(track.getSampleRate(), track.getSampleSize(), track.getChannelCount(), true, true);
        }
        byte[] outputStreamByteArray = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStreamByteArray);
        return new AudioInputStream(inputStream, audioFormat, outputStreamByteArray.length);
    }
}

