/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xiph.speex.AudioFileWriter;
import org.xiph.speex.Encoder;
import org.xiph.speex.OggCrc;
import org.xiph.speex.SpeexEncoder;
import org.xiph.speex.spi.FilteredAudioInputStream;
import org.xiph.speex.spi.SpeexEncoding;

public class Pcm2SpeexAudioInputStream
extends FilteredAudioInputStream {
    public static final int DEFAULT_BUFFER_SIZE = 2560;
    public static final int DEFAULT_SAMPLERATE = 8000;
    public static final int DEFAULT_CHANNELS = 1;
    public static final int DEFAULT_QUALITY = 3;
    public static final int DEFAULT_FRAMES_PER_PACKET = 1;
    public static final int DEFAULT_PACKETS_PER_OGG_PAGE = 20;
    public static final int UNKNOWN = -1;
    private final SpeexEncoder encoder;
    private final int mode;
    private final int frameSize;
    private int framesPerPacket;
    private int channels;
    @Nullable
    private String comment = null;
    private int granulepos = 0;
    private int streamSerialNumber;
    private int packetsPerOggPage;
    private int packetCount;
    private int pageCount;
    private int oggCount;
    private boolean first;

    public Pcm2SpeexAudioInputStream(InputStream in, @NotNull AudioFormat format, long length) {
        this(-1, -1, in, format, length, 2560);
    }

    public Pcm2SpeexAudioInputStream(int mode, int quality, InputStream in, @NotNull AudioFormat format, long length) {
        this(mode, quality, in, format, length, 2560);
    }

    public Pcm2SpeexAudioInputStream(InputStream in, @NotNull AudioFormat format, long length, int size) {
        this(-1, -1, in, format, length, size);
    }

    public Pcm2SpeexAudioInputStream(int mode, int quality, InputStream in, @NotNull AudioFormat format, long length, int size) {
        super(in, format, length, size);
        if (this.streamSerialNumber == 0) {
            this.streamSerialNumber = new Random().nextInt();
        }
        this.packetsPerOggPage = 20;
        this.packetCount = 0;
        this.pageCount = 0;
        this.framesPerPacket = 1;
        int samplerate = (int)format.getSampleRate();
        if (samplerate < 0) {
            samplerate = 8000;
        }
        this.channels = format.getChannels();
        if (this.channels < 0) {
            this.channels = 1;
        }
        if (mode < 0) {
            mode = samplerate < 12000 ? 0 : (samplerate < 24000 ? 1 : 2);
        }
        this.mode = mode;
        AudioFormat.Encoding encoding = format.getEncoding();
        if (quality < 0) {
            quality = encoding instanceof SpeexEncoding ? ((SpeexEncoding)encoding).getQuality() : 3;
        }
        this.encoder = new SpeexEncoder();
        this.encoder.init(mode, quality, samplerate, this.channels);
        if (encoding instanceof SpeexEncoding && ((SpeexEncoding)encoding).isVBR()) {
            this.setVbr(true);
        } else {
            this.setVbr(false);
        }
        this.frameSize = 2 * this.channels * this.encoder.getFrameSize();
        this.comment = "Encoded with Java Speex Encoder v0.9.7 ($Revision$)";
        this.first = true;
    }

    public void setSerialNumber(int serialNumber) {
        if (this.first) {
            this.streamSerialNumber = serialNumber;
        }
    }

    public void setFramesPerPacket(int framesPerPacket) {
        if (framesPerPacket <= 0) {
            framesPerPacket = 1;
        }
        this.framesPerPacket = framesPerPacket;
    }

    public void setPacketsPerOggPage(int packetsPerOggPage) {
        if (packetsPerOggPage <= 0) {
            packetsPerOggPage = 20;
        }
        if (packetsPerOggPage > 255) {
            packetsPerOggPage = 255;
        }
        this.packetsPerOggPage = packetsPerOggPage;
    }

    public void setComment(String comment, boolean appendVersion) {
        this.comment = comment;
        if (appendVersion) {
            this.comment = this.comment + "Java Speex Encoder v0.9.7 ($Revision$)";
        }
    }

    public void setQuality(int quality) {
        this.encoder.getEncoder().setQuality(quality);
        if (this.encoder.getEncoder().getVbr()) {
            this.encoder.getEncoder().setVbrQuality(quality);
        }
    }

    public void setVbr(boolean vbr) {
        this.encoder.getEncoder().setVbr(vbr);
    }

    public Encoder getEncoder() {
        return this.encoder.getEncoder();
    }

    protected void fill() throws IOException {
        block18: {
            this.makeSpace();
            if (this.first) {
                this.writeHeaderFrames();
                this.first = false;
            }
            while (true) {
                int read;
                if (this.prebuf.length - this.prepos < this.framesPerPacket * this.frameSize * this.packetsPerOggPage) {
                    int nsz = this.prepos + this.framesPerPacket * this.frameSize * this.packetsPerOggPage;
                    byte[] nbuf = new byte[nsz];
                    System.arraycopy(this.prebuf, 0, nbuf, 0, this.precount);
                    this.prebuf = nbuf;
                }
                if ((read = this.in.read(this.prebuf, this.precount, this.prebuf.length - this.precount)) < 0) {
                    if ((this.precount - this.prepos) % 2 != 0) {
                        throw new StreamCorruptedException("Incompleted last PCM sample when stream ended");
                    }
                    while (this.prepos < this.precount) {
                        if (this.precount - this.prepos < this.framesPerPacket * this.frameSize) {
                            while (this.precount < this.prepos + this.framesPerPacket * this.frameSize) {
                                this.prebuf[this.precount] = 0;
                                ++this.precount;
                            }
                        }
                        if (this.packetCount == 0) {
                            this.writeOggPageHeader(this.packetsPerOggPage, 0);
                        }
                        for (int i = 0; i < this.framesPerPacket; ++i) {
                            this.encoder.processData(this.prebuf, this.prepos, this.frameSize);
                            this.prepos += this.frameSize;
                        }
                        int size = this.encoder.getProcessedDataByteSize();
                        while (this.buf.length - this.oggCount < size) {
                            int nsz = this.buf.length * 2;
                            byte[] nbuf = new byte[nsz];
                            System.arraycopy(this.buf, 0, nbuf, 0, this.oggCount);
                            this.buf = nbuf;
                        }
                        this.buf[this.count + 27 + this.packetCount] = (byte)(0xFF & size);
                        this.encoder.getProcessedData(this.buf, this.oggCount);
                        this.oggCount += size;
                        ++this.packetCount;
                        if (this.packetCount < this.packetsPerOggPage) continue;
                        this.writeOggPageChecksum();
                        return;
                    }
                    if (this.packetCount > 0) {
                        this.buf[this.count + 5] = 4;
                        this.buf[this.count + 26] = (byte)(0xFF & this.packetCount);
                        System.arraycopy(this.buf, this.count + 27 + this.packetsPerOggPage, this.buf, this.count + 27 + this.packetCount, this.oggCount - (this.count + 27 + this.packetsPerOggPage));
                        this.oggCount -= this.packetsPerOggPage - this.packetCount;
                        this.writeOggPageChecksum();
                    }
                    return;
                }
                if (read > 0) {
                    this.precount += read;
                    if (this.precount - this.prepos < this.framesPerPacket * this.frameSize * this.packetsPerOggPage) continue;
                    while (this.precount - this.prepos >= this.framesPerPacket * this.frameSize * this.packetsPerOggPage) {
                        if (this.packetCount == 0) {
                            this.writeOggPageHeader(this.packetsPerOggPage, 0);
                        }
                        while (this.packetCount < this.packetsPerOggPage) {
                            for (int i = 0; i < this.framesPerPacket; ++i) {
                                this.encoder.processData(this.prebuf, this.prepos, this.frameSize);
                                this.prepos += this.frameSize;
                            }
                            int size = this.encoder.getProcessedDataByteSize();
                            while (this.buf.length - this.oggCount < size) {
                                int nsz = this.buf.length * 2;
                                byte[] nbuf = new byte[nsz];
                                System.arraycopy(this.buf, 0, nbuf, 0, this.oggCount);
                                this.buf = nbuf;
                            }
                            this.buf[this.count + 27 + this.packetCount] = (byte)(0xFF & size);
                            this.encoder.getProcessedData(this.buf, this.oggCount);
                            this.oggCount += size;
                            ++this.packetCount;
                        }
                        if (this.packetCount < this.packetsPerOggPage) continue;
                        this.writeOggPageChecksum();
                    }
                    System.arraycopy(this.prebuf, this.prepos, this.prebuf, 0, this.precount - this.prepos);
                    this.precount -= this.prepos;
                    this.prepos = 0;
                    return;
                }
                if (this.precount < this.prebuf.length) break block18;
                if (this.prepos <= 0) break;
                System.arraycopy(this.prebuf, this.prepos, this.prebuf, 0, this.precount - this.prepos);
                this.precount -= this.prepos;
                this.prepos = 0;
            }
            return;
        }
    }

    public synchronized int available() throws IOException {
        int avail = super.available();
        int unencoded = this.precount - this.prepos + this.in.available();
        if (this.encoder.getEncoder().getVbr()) {
            switch (this.mode) {
                case 0: {
                    return avail + (27 + 2 * this.packetsPerOggPage) * (unencoded / (this.packetsPerOggPage * this.framesPerPacket * 320));
                }
                case 1: {
                    return avail + (27 + 2 * this.packetsPerOggPage) * (unencoded / (this.packetsPerOggPage * this.framesPerPacket * 640));
                }
                case 2: {
                    return avail + (27 + 3 * this.packetsPerOggPage) * (unencoded / (this.packetsPerOggPage * this.framesPerPacket * 1280));
                }
            }
            return avail;
        }
        int spxpacketsize = this.encoder.getEncoder().getEncodedFrameSize();
        if (this.channels > 1) {
            spxpacketsize += 17;
        }
        spxpacketsize *= this.framesPerPacket;
        spxpacketsize = spxpacketsize + 7 >> 3;
        int oggpacketsize = 27 + this.packetsPerOggPage * (spxpacketsize + 1);
        switch (this.mode) {
            case 0: {
                int pcmframesize = this.framesPerPacket * 320 * this.encoder.getChannels();
                return avail += oggpacketsize * (unencoded / (this.packetsPerOggPage * pcmframesize));
            }
            case 1: {
                int pcmframesize = this.framesPerPacket * 640 * this.encoder.getChannels();
                return avail += oggpacketsize * (unencoded / (this.packetsPerOggPage * pcmframesize));
            }
            case 2: {
                int pcmframesize = this.framesPerPacket * 1280 * this.encoder.getChannels();
                return avail += oggpacketsize * (unencoded / (this.packetsPerOggPage * pcmframesize));
            }
        }
        return avail;
    }

    private void writeOggPageHeader(int packets, int headertype) {
        while (this.buf.length - this.count < 27 + packets) {
            int nsz = this.buf.length * 2;
            byte[] nbuf = new byte[nsz];
            System.arraycopy(this.buf, 0, nbuf, 0, this.count);
            this.buf = nbuf;
        }
        AudioFileWriter.writeOggPageHeader(this.buf, this.count, headertype, this.granulepos, this.streamSerialNumber, this.pageCount++, packets, new byte[packets]);
        this.oggCount = this.count + 27 + packets;
    }

    private void writeOggPageChecksum() {
        this.granulepos += this.framesPerPacket * this.frameSize * this.packetCount / 2;
        AudioFileWriter.writeLong(this.buf, this.count + 6, this.granulepos);
        int chksum = OggCrc.checksum(0, this.buf, this.count, this.oggCount - this.count);
        AudioFileWriter.writeInt(this.buf, this.count + 22, chksum);
        this.count = this.oggCount;
        this.packetCount = 0;
    }

    private void writeHeaderFrames() {
        int length = this.comment.length();
        if (length > 247) {
            this.comment = this.comment.substring(0, 247);
            length = 247;
        }
        while (this.buf.length - this.count < length + 144) {
            int nsz = this.buf.length * 2;
            byte[] nbuf = new byte[nsz];
            System.arraycopy(this.buf, 0, nbuf, 0, this.count);
            this.buf = nbuf;
        }
        AudioFileWriter.writeOggPageHeader(this.buf, this.count, 2, this.granulepos, this.streamSerialNumber, this.pageCount++, 1, new byte[]{80});
        this.oggCount = this.count + 28;
        AudioFileWriter.writeSpeexHeader(this.buf, this.oggCount, this.encoder.getSampleRate(), this.mode, this.encoder.getChannels(), this.encoder.getEncoder().getVbr(), this.framesPerPacket);
        this.oggCount += 80;
        int chksum = OggCrc.checksum(0, this.buf, this.count, this.oggCount - this.count);
        AudioFileWriter.writeInt(this.buf, this.count + 22, chksum);
        this.count = this.oggCount;
        AudioFileWriter.writeOggPageHeader(this.buf, this.count, 0, this.granulepos, this.streamSerialNumber, this.pageCount++, 1, new byte[]{(byte)(length + 8)});
        this.oggCount = this.count + 28;
        AudioFileWriter.writeSpeexComment(this.buf, this.oggCount, this.comment);
        this.oggCount += length + 8;
        chksum = OggCrc.checksum(0, this.buf, this.count, this.oggCount - this.count);
        AudioFileWriter.writeInt(this.buf, this.count + 22, chksum);
        this.count = this.oggCount;
        this.packetCount = 0;
    }
}

