/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Scanner;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Player;
import org.muplayer.main.ConsoleInterpreter;
import org.muplayer.system.AppInfo;
import org.muplayer.system.SysInfo;
import org.muplayer.thread.TaskRunner;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public class ConsolePlayer
implements Runnable {
    protected volatile Player player;
    protected volatile ConsoleInterpreter interpreter;
    protected volatile File playerFolder;
    protected volatile Scanner scanner;
    protected static final String LINEHEADER = "[MuPlayer]> ";

    public ConsolePlayer(File rootFolder) throws FileNotFoundException {
        this.player = new Player(rootFolder);
        this.interpreter = new ConsoleInterpreter(this.player);
        this.playerFolder = rootFolder;
        this.scanner = new Scanner(System.in);
    }

    public ConsolePlayer(String folder) throws FileNotFoundException {
        this(new File(folder));
    }

    protected void printHeader() {
        FileOutputStream stdout = SystemUtil.getStdout();
        try {
            stdout.write(Logger.getLogger(this, (Object)LINEHEADER).getColoredMsg("\u001b[32m").getBytes());
            stdout.flush();
        }
        catch (IOException e) {
            Logger.getLogger(this, e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void execCommand(String strCmd) {
        try {
            this.interpreter.preInterprate(strCmd);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (SysInfo.VERSION == null) {
            Logger.getLogger(this, (Object)"MuPlayer started...").rawInfo();
        } else {
            Logger.getLogger(this, (Object)("MuPlayer v" + SysInfo.VERSION + " started...")).rawInfo();
        }
        this.interpreter.setOn(true);
        while (this.interpreter.isOn()) {
            this.printHeader();
            this.execCommand(this.scanner.nextLine().trim());
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                String defaultRootPath = AppInfo.getInstance().get("root_folder");
                if (defaultRootPath == null) {
                    throw new NullPointerException("Property 'root_folder' must be configured.\nIf you want to load a folder path automatically, create a file called config.properties in the path of the jar file and set the root_folder property indicating the path of your music folder");
                }
                TaskRunner.execute(new ConsolePlayer(defaultRootPath));
            } else {
                TaskRunner.execute(new ConsolePlayer(args[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

