/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class TestingManager {
    private Properties props = new Properties();
    private File fileTestingInfo = new File("testingInfo.properties");

    public TestingManager() throws IOException {
        if (this.fileTestingInfo.exists()) {
            this.loadData();
        } else {
            this.fileTestingInfo.createNewFile();
            this.saveDefaultData();
        }
    }

    private void loadData() {
        try {
            this.props.load(new FileInputStream(this.fileTestingInfo));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDefaultData() {
        this.props.setProperty("test-path", "/home/martin/AudioTesting/test/");
        this.saveData();
    }

    private void saveData() {
        try {
            this.props.store(new FileOutputStream(this.fileTestingInfo), "Testing Information");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
        this.saveData();
    }
}

