/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.api;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sourceforge.jaad.mp4.boxes.impl.meta.ITunesMetadataBox;

public class Artwork {
    private Type type;
    private byte[] data;
    private Image image;

    Artwork(Type type, byte[] data) {
        this.type = type;
        this.data = data;
    }

    public Type getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public Image getImage() throws IOException {
        try {
            if (this.image == null) {
                this.image = ImageIO.read(new ByteArrayInputStream(this.data));
            }
            return this.image;
        }
        catch (IOException e) {
            Logger.getLogger("MP4 API").log(Level.SEVERE, "Artwork.getImage failed: {0}", e.toString());
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        GIF,
        JPEG,
        PNG,
        BMP;


        static Type forDataType(ITunesMetadataBox.DataType dataType) {
            Type type;
            switch (dataType) {
                case GIF: {
                    type = GIF;
                    break;
                }
                case JPEG: {
                    type = JPEG;
                    break;
                }
                case PNG: {
                    type = PNG;
                    break;
                }
                case BMP: {
                    type = BMP;
                    break;
                }
                default: {
                    type = null;
                }
            }
            return type;
        }
    }
}

