/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.trackstates;

import java.io.IOException;
import org.aucom.sound.Speaker;
import org.muplayer.audio.Track;
import org.muplayer.audio.trackstates.TrackState;
import org.muplayer.thread.TPlayingTrack;
import org.muplayer.thread.TaskRunner;
import org.orangelogger.sys.Logger;

public class PlayingState
extends TrackState {
    private final Speaker trackLine;
    private final short BUFF_SIZE = (short)4096;
    private final byte[] audioBuffer = new byte[4096];

    public PlayingState(Track track) {
        super(track);
        this.trackLine = track.getTrackLine();
    }

    @Override
    public void handle() {
        TPlayingTrack trackThread = this.track.getPlayingTrack();
        if (trackThread == null || !trackThread.hasTrack(this.track)) {
            TPlayingTrack tPlayingTrack = new TPlayingTrack(this.track);
            this.track.setPlayingTrack(tPlayingTrack);
            TaskRunner.execute(tPlayingTrack);
        }
        while (this.track.isPlaying()) {
            try {
                int read = this.track.getDecodedStream().read(this.audioBuffer);
                if (read == -1) {
                    this.track.finish();
                }
                if (this.trackLine == null) continue;
                this.trackLine.playAudio(this.audioBuffer);
            }
            catch (IOException | IllegalArgumentException | IndexOutOfBoundsException e) {
                this.track.finish();
                Logger.getLogger(this, (Object)e.getMessage()).error();
            }
        }
    }
}

