/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.tests;

import java.util.Arrays;
import java.util.stream.Stream;

public class TestArray {
    public static void main(String[] args) {
        int lenght = 100000000;
        String[] array = TestArray.getArray(100000000);
        System.out.println("Time test with 100000000 elements");
        TestArray.printMsg("Sequential time: ", TestArray.forArraySequential(array));
        TestArray.printMsg("Parallel time: ", TestArray.forArrayParallel(array));
    }

    private static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private static void printMsg(String msg, long time) {
        System.out.println(msg.concat(String.valueOf(time)));
    }

    private static String[] getArray(int lenght) {
        String[] array = new String[lenght];
        for (int i = 0; i < lenght; ++i) {
            array[i] = "Element " + i;
        }
        return array;
    }

    private static long forArraySequential(String[] array) {
        long ti = TestArray.getCurrentTime();
        for (int i = 0; i < array.length; ++i) {
        }
        long tf = TestArray.getCurrentTime();
        return tf - ti;
    }

    private static long forArrayParallel(String[] array) {
        if (!((Stream)Arrays.stream(array).parallel()).isParallel()) {
            throw new RuntimeException("Error! Stream is not parallel");
        }
        long ti = TestArray.getCurrentTime();
        ((Stream)Arrays.stream(array).parallel()).forEach(element -> {});
        long tf = TestArray.getCurrentTime();
        return tf - ti;
    }
}

