/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.format;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Track;
import org.muplayer.audio.interfaces.PlayerControls;
import org.muplayer.system.AudioUtil;
import org.xiph.speex.spi.SpeexAudioFileReader;
import org.xiph.speex.spi.SpeexFormatConvertionProvider;

public class SpeexTrack
extends Track {
    public SpeexTrack(File dataSource) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource);
    }

    public SpeexTrack(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream);
    }

    public SpeexTrack(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath);
    }

    public SpeexTrack(File dataSource, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource, player);
    }

    public SpeexTrack(InputStream inputStream, PlayerControls player) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream, player);
    }

    public SpeexTrack(String trackPath, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath, player);
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        SpeexFormatConvertionProvider provider = new SpeexFormatConvertionProvider();
        this.audioReader = new SpeexAudioFileReader();
        AudioInputStream soundAis = AudioUtil.instanceStream(this.audioReader, this.source);
        if (this.trackStream != null) {
            this.trackStream.close();
        }
        this.trackStream = provider.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, soundAis);
    }

    @Override
    protected double convertSecondsToBytes(Number seconds) {
        AudioFormat audioFormat = this.getAudioFormat();
        float frameRate = audioFormat.getFrameRate();
        int frameSize = audioFormat.getFrameSize();
        double framesToSeek = (double)frameRate * seconds.doubleValue();
        return framesToSeek * (double)frameSize;
    }

    @Override
    protected double convertBytesToSeconds(Number bytes) {
        AudioFormat audioFormat = this.getAudioFormat();
        return bytes.doubleValue() / (double)audioFormat.getFrameSize() / (double)audioFormat.getFrameRate();
    }

    @Override
    public long getDuration() {
        try {
            AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(this.dataSource);
            return 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

