/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.format.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import org.bytebuffer.ByteBuffer;
import org.muplayer.audio.format.io.AudioDataInputStream;

public class M4AInputStream
extends AudioDataInputStream {
    private AudioTrack audioTrack;
    private Decoder decoder;
    private RandomAccessFile randomAccessFile;
    private Frame frame;
    private SampleBuffer sampleBuffer;

    public M4AInputStream(AudioTrack audioTrack, Decoder decoder, RandomAccessFile randomAccessFile) {
        this(new ByteBuffer(), audioTrack, decoder, randomAccessFile);
    }

    public M4AInputStream(ByteBuffer byteBuffer, AudioTrack audioTrack, Decoder decoder, RandomAccessFile randomAccessFile) {
        super(byteBuffer);
        this.audioTrack = audioTrack;
        this.decoder = decoder;
        this.randomAccessFile = randomAccessFile;
        this.sampleBuffer = new SampleBuffer();
    }

    private Frame getNextFrame() throws IOException {
        return this.audioTrack.readNextFrame();
    }

    private byte[] decodeNextFrame() throws IOException {
        this.frame = this.getNextFrame();
        if (this.frame != null) {
            this.decoder.decodeFrame(this.frame.getData(), this.sampleBuffer);
            return this.sampleBuffer.getData();
        }
        return null;
    }

    private int readNextFrame() throws IOException {
        byte[] frameBytes = this.decodeNextFrame();
        if (frameBytes != null) {
            this.byteBuffer.addFrom(frameBytes);
        }
        return frameBytes == null ? -1 : frameBytes.length;
    }

    public double getFrameTime() {
        return this.frame == null ? 0.0 : this.frame.getTime();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (this.available() < len && this.readNextFrame() != -1) {
        }
        return super.read(b, off, len);
    }

    @Override
    public long skip(long seconds) throws IOException {
        double currentTime = this.getFrameTime();
        if (this.audioTrack.hasMoreFrames()) {
            double frameTime;
            while ((this.frame = this.getNextFrame()) != null && (long)((frameTime = this.frame.getTime()) - currentTime) < seconds) {
            }
        } else {
            seconds = 0L;
        }
        return seconds;
    }

    @Override
    public int available() throws IOException {
        return super.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.randomAccessFile.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }
}

