/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.trackstates;

import java.io.IOException;
import org.aucom.sound.Speaker;
import org.muplayer.audio.Track;
import org.muplayer.audio.trackstates.TrackState;
import org.muplayer.thread.TPlayingTrack;
import org.muplayer.thread.TaskRunner;
import org.orangelogger.sys.Logger;

public class PlayingState
extends TrackState {
    private final Speaker trackLine;
    private final short BUFF_SIZE = (short)4096;
    private final byte[] audioBuffer = new byte[4096];
    private final int EOF = -1;

    public PlayingState(Track track) {
        super(track);
        this.trackLine = track.getTrackLine();
    }

    private boolean canPlay() throws IOException {
        return this.trackLine != null && this.readNextBytes() != -1;
    }

    private int readNextBytes() throws IOException {
        return this.track.getDecodedStream().read(this.audioBuffer);
    }

    private void checkTrackThread() {
        TPlayingTrack trackThread = this.track.getPlayingTrack();
        if (trackThread == null || !trackThread.hasTrack(this.track)) {
            TPlayingTrack tPlayingTrack = new TPlayingTrack(this.track);
            this.track.setPlayingTrack(tPlayingTrack);
            TaskRunner.execute(tPlayingTrack);
        }
    }

    @Override
    public void handle() {
        try {
            this.checkTrackThread();
            while (this.track.isPlaying()) {
                if (this.canPlay()) {
                    this.trackLine.playAudio(this.audioBuffer);
                    continue;
                }
                this.track.finish();
            }
        }
        catch (IOException | IllegalArgumentException | IndexOutOfBoundsException e) {
            this.track.finish();
            e.printStackTrace();
            String exClassName = e.getClass().getSimpleName();
            Logger.getLogger(this, (Object)exClassName.concat(" in track " + this.track.getTitle())).error();
        }
    }
}

