/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex.spi;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredAudioInputStream
extends AudioInputStream {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    @Nullable
    protected InputStream in;
    @Nullable
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos;
    protected int marklimit;
    private final byte[] single = new byte[1];
    @Nullable
    protected byte[] prebuf;
    protected int precount;
    protected int prepos;

    protected void checkIfStillOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public FilteredAudioInputStream(InputStream in, @NotNull AudioFormat format, long length) {
        this(in, format, length, 2048);
    }

    public FilteredAudioInputStream(InputStream in, @NotNull AudioFormat format, long length, int size) {
        this(in, format, length, size, size);
    }

    public FilteredAudioInputStream(@Nullable InputStream in, @NotNull AudioFormat format, long length, int size, int presize) {
        super(in, format, length);
        this.in = in;
        if (size <= 0 || presize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
        this.count = 0;
        this.prebuf = new byte[presize];
        this.precount = 0;
        this.marklimit = size;
        this.markpos = -1;
    }

    protected void fill() throws IOException {
        int read;
        this.makeSpace();
        while ((read = this.in.read(this.prebuf, this.precount, this.prebuf.length - this.precount)) >= 0) {
            if (read <= 0) continue;
            this.precount += read;
            break;
        }
    }

    protected void makeSpace() {
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, sz);
                this.pos = sz;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                int nsz = this.pos * 2;
                if (nsz > this.marklimit) {
                    nsz = this.marklimit;
                }
                byte[] nbuf = new byte[nsz];
                System.arraycopy(this.buf, 0, nbuf, 0, this.pos);
                this.buf = nbuf;
            }
        }
        this.count = this.pos;
    }

    public synchronized int read() throws IOException {
        if (this.read(this.single, 0, 1) == -1) {
            return -1;
        }
        return this.single[0] & 0xFF;
    }

    public synchronized int read(@NotNull byte[] b, int off, int len) throws IOException {
        this.checkIfStillOpen();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int avail = this.count - this.pos;
        if (avail <= 0) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    public synchronized long skip(long n) throws IOException {
        this.checkIfStillOpen();
        if (n <= 0L) {
            return 0L;
        }
        if (this.pos < this.count) {
            int avail = this.count - this.pos;
            if ((long)avail > n) {
                this.pos = (int)((long)this.pos + n);
                return n;
            }
            this.pos = this.count;
            return avail;
        }
        this.fill();
        int avail = this.count - this.pos;
        if (avail <= 0) {
            return 0L;
        }
        long skipped = (long)avail < n ? (long)avail : n;
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    public synchronized int available() throws IOException {
        this.checkIfStillOpen();
        return this.count - this.pos;
    }

    public synchronized void mark(int readlimit) {
        if (readlimit > this.buf.length - this.pos) {
            byte[] newbuf = readlimit <= this.buf.length ? this.buf : new byte[readlimit];
            System.arraycopy(this.buf, this.pos, newbuf, 0, this.count - this.pos);
            this.buf = newbuf;
            this.count -= this.pos;
            this.markpos = 0;
            this.pos = 0;
        } else {
            this.markpos = this.pos;
        }
        this.marklimit = readlimit;
    }

    public synchronized void reset() throws IOException {
        this.checkIfStillOpen();
        if (this.markpos < 0) {
            throw new IOException("Attempt to reset when no mark is valid");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
        this.prebuf = null;
    }
}

