/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.internal.toolkit.PackageSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;

public class PackageWriterImpl
extends HtmlDocletWriter
implements PackageSummaryWriter {
    protected PackageDoc prev;
    protected PackageDoc next;
    protected PackageDoc packageDoc;
    private static final String OUTPUT_FILE_NAME = "package-summary.html";

    public PackageWriterImpl(ConfigurationImpl configurationImpl, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3) throws IOException {
        super(configurationImpl, DirectoryManager.getDirectoryPath(packageDoc), OUTPUT_FILE_NAME, DirectoryManager.getRelativePath(packageDoc.name()));
        this.prev = packageDoc2;
        this.next = packageDoc3;
        this.packageDoc = packageDoc;
    }

    public String getOutputFileName() {
        return OUTPUT_FILE_NAME;
    }

    public void writeSummaryHeader() {
    }

    public void writeSummaryFooter() {
    }

    public void writeClassesSummary(ClassDoc[] classDocArray, String string) {
        if (classDocArray.length > 0) {
            Arrays.sort(classDocArray);
            this.tableIndexSummary();
            boolean bl = false;
            for (int i = 0; i < classDocArray.length; ++i) {
                if (!bl) {
                    this.printFirstRow(string);
                    bl = true;
                }
                if (!Util.isCoreClass(classDocArray[i]) || !this.configuration.isGeneratedDoc(classDocArray[i])) continue;
                this.trBgcolorStyle("white", "TableRowColor");
                this.summaryRow(15);
                this.bold();
                this.printLink(new LinkInfoImpl(9, classDocArray[i], false));
                this.boldEnd();
                this.summaryRowEnd();
                this.summaryRow(0);
                if (Util.isDeprecated(classDocArray[i])) {
                    this.boldText("doclet.Deprecated");
                    if (classDocArray[i].tags("deprecated").length > 0) {
                        this.space();
                        this.printSummaryDeprecatedComment(classDocArray[i], classDocArray[i].tags("deprecated")[0]);
                    }
                } else {
                    this.printSummaryComment(classDocArray[i]);
                }
                this.summaryRowEnd();
                this.trEnd();
            }
            this.tableEnd();
            this.println("&nbsp;");
            this.p();
        }
    }

    protected void printFirstRow(String string) {
        this.tableHeaderStart("#CCCCFF");
        this.bold(string);
        this.tableHeaderEnd();
    }

    public void writePackageDescription() {
        if (this.packageDoc.inlineTags().length > 0) {
            this.anchor("package_description");
            this.h2(this.configuration.getText("doclet.Package_Description", this.packageDoc.name()));
            this.p();
            this.printInlineComment(this.packageDoc);
            this.p();
        }
    }

    public void writePackageTags() {
        this.printTags(this.packageDoc);
    }

    public void writePackageHeader(String string) {
        String string2 = this.packageDoc.name();
        String[] stringArray = new String[]{string2 + " " + "package"};
        this.printHtmlHeader(string2, stringArray, true);
        this.navLinks(true);
        this.hr();
        this.writeAnnotationInfo(this.packageDoc);
        this.h2(this.configuration.getText("doclet.Package") + " " + string);
        if (this.packageDoc.inlineTags().length > 0 && !this.configuration.nocomment) {
            this.printSummaryComment(this.packageDoc);
            this.p();
            this.bold(this.configuration.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "package_description", this.configuration.getText("doclet.Description"), true);
            this.p();
        }
    }

    public void writePackageFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.printHyperLink("package-use.html", "", this.configuration.getText("doclet.navClassUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Package");
        } else {
            String string = DirectoryManager.getRelativePath(this.packageDoc.name(), this.prev.name());
            this.printHyperLink(string + OUTPUT_FILE_NAME, "", this.configuration.getText("doclet.Prev_Package"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Package");
        } else {
            String string = DirectoryManager.getRelativePath(this.packageDoc.name(), this.next.name());
            this.printHyperLink(string + OUTPUT_FILE_NAME, "", this.configuration.getText("doclet.Next_Package"), true);
        }
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPackage() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Package");
        this.fontEnd();
        this.navCellEnd();
    }
}

