/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.format;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.muplayer.audio.Track;
import org.muplayer.audio.TrackIO;
import org.muplayer.audio.codec.DecodeManager;
import org.muplayer.audio.interfaces.PlayerControls;
import org.muplayer.util.AudioUtil;
import org.tritonus.sampled.file.jorbis.JorbisAudioFileReader;

public class OGGTrack
extends Track {
    public OGGTrack(File dataSource) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(dataSource);
    }

    public OGGTrack(String trackPath) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        this(new File(trackPath));
    }

    public OGGTrack(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream);
    }

    public OGGTrack(File dataSource, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource, player);
    }

    public OGGTrack(InputStream inputStream, PlayerControls player) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        super(inputStream, player);
    }

    public OGGTrack(String trackPath, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath, player);
    }

    private AudioInputStream createAudioStream() throws IOException, UnsupportedAudioFileException {
        this.trackIO.setAudioReader(new JorbisAudioFileReader());
        AudioInputStream soundEncodedStream = AudioUtil.instanceStream(this.trackIO.getAudioReader(), this.dataSource);
        return DecodeManager.decodeToPcm(soundEncodedStream);
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        this.trackIO = new TrackIO();
        this.trackIO.setDecodedStream(this.createAudioStream());
    }

    @Override
    protected double convertSecondsToBytes(Number seconds) {
        AudioFormat audioFormat = this.trackIO.getAudioFormat();
        float frameRate = audioFormat.getFrameRate();
        int frameSize = audioFormat.getFrameSize();
        double framesToSeek = (double)frameRate * seconds.doubleValue();
        return framesToSeek * (double)frameSize;
    }

    @Override
    protected double convertBytesToSeconds(Number bytes) {
        AudioFormat audioFormat = this.trackIO.getAudioFormat();
        return bytes.doubleValue() / (double)audioFormat.getFrameSize() / (double)audioFormat.getFrameRate();
    }
}

