/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.info;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.datatype.Artwork;

public class AudioTag {
    private final File fileSource;
    private final AudioFile audioFile;
    private final Tag tagReader;
    private final AudioHeader header;

    public AudioTag(Object sound) throws TagException, ReadOnlyFileException, CannotReadException, InvalidAudioFrameException, IOException {
        if (sound instanceof File) {
            this.fileSource = (File)sound;
            this.audioFile = AudioFileIO.read(this.fileSource);
            this.tagReader = this.audioFile.getTag();
            this.header = this.audioFile.getAudioHeader();
        } else {
            this.fileSource = null;
            this.audioFile = null;
            this.tagReader = null;
            this.header = null;
        }
    }

    public AudioTag(String soundPath) throws ReadOnlyFileException, IOException, TagException, InvalidAudioFrameException, CannotReadException {
        this(new File(soundPath));
    }

    public boolean isValidFile() {
        return this.tagReader != null;
    }

    public boolean hasCover() {
        return this.isValidFile() && this.getCover() != null;
    }

    public Iterator<TagField> getTags() {
        return this.tagReader.getFields();
    }

    public String getTag(FieldKey tag) {
        if (this.tagReader == null) {
            return null;
        }
        String tagValue = this.tagReader.getFirst(tag);
        return tagValue == null || tagValue.isEmpty() ? null : tagValue.trim();
    }

    public String getTag(String tagName) {
        return this.getTag(FieldKey.valueOf(tagName.toUpperCase()));
    }

    public int getDuration() {
        return this.header.getTrackLength();
    }

    public Artwork getCover() {
        return this.tagReader != null ? this.tagReader.getFirstArtwork() : null;
    }

    public byte[] getCoverData() {
        return this.hasCover() ? this.getCover().getBinaryData() : null;
    }

    public File getFileSource() {
        return this.fileSource;
    }

    public AudioFile getAudioFile() {
        return this.audioFile;
    }

    public Tag getTagReader() {
        return this.tagReader;
    }

    public AudioHeader getHeader() {
        return this.header;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioTag)) {
            return false;
        }
        AudioTag other = (AudioTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$fileSource = this.getFileSource();
        File other$fileSource = other.getFileSource();
        if (this$fileSource == null ? other$fileSource != null : !((Object)this$fileSource).equals(other$fileSource)) {
            return false;
        }
        AudioFile this$audioFile = this.getAudioFile();
        AudioFile other$audioFile = other.getAudioFile();
        if (this$audioFile == null ? other$audioFile != null : !this$audioFile.equals(other$audioFile)) {
            return false;
        }
        Tag this$tagReader = this.getTagReader();
        Tag other$tagReader = other.getTagReader();
        if (this$tagReader == null ? other$tagReader != null : !this$tagReader.equals(other$tagReader)) {
            return false;
        }
        AudioHeader this$header = this.getHeader();
        AudioHeader other$header = other.getHeader();
        return !(this$header == null ? other$header != null : !this$header.equals(other$header));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AudioTag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $fileSource = this.getFileSource();
        result = result * 59 + ($fileSource == null ? 43 : ((Object)$fileSource).hashCode());
        AudioFile $audioFile = this.getAudioFile();
        result = result * 59 + ($audioFile == null ? 43 : $audioFile.hashCode());
        Tag $tagReader = this.getTagReader();
        result = result * 59 + ($tagReader == null ? 43 : $tagReader.hashCode());
        AudioHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        return result;
    }

    public String toString() {
        return "AudioTag(fileSource=" + this.getFileSource() + ", audioFile=" + this.getAudioFile() + ", tagReader=" + this.getTagReader() + ", header=" + this.getHeader() + ")";
    }
}

