/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.datatype.Artwork;

public class AudioInfo {
    private AudioFile audioFile;
    private Tag fileTag;
    private AudioHeader header;

    public AudioInfo(File sound) throws TagException, ReadOnlyFileException, CannotReadException, InvalidAudioFrameException, IOException {
        this.audioFile = AudioFileIO.read(sound);
        this.fileTag = this.audioFile.getTag();
        this.header = this.audioFile.getAudioHeader();
    }

    public File getDataSource() {
        return this.audioFile.getFile();
    }

    public String getTag(FieldKey tag) {
        return this.fileTag.getFirst(tag);
    }

    public String getTag(String tagName) {
        return this.getTag(FieldKey.valueOf(tagName.toUpperCase()));
    }

    public int getDuration() {
        return this.header.getTrackLength();
    }

    public Artwork getCover() {
        return this.fileTag.getFirstArtwork();
    }

    public List<Artwork> getCovers() {
        return this.fileTag.getArtworkList();
    }
}

